%%
%% CEMtran.cls 2013/10/15 version V1.0
%% 
%% 

\ProvidesClass{CEMconf}[2013/10/15 by SL]
%\typeout{-- See the "CEMconf_HOWTO" manual for usage information.}
%\typeout{-- http://www.michaelshell.org/tex/ieeetran/}
\NeedsTeXFormat{LaTeX2e}

\def\CEMconfsversionmajor{1}
\def\CEMconfsversionminor{7}

\newif\if@restonecol
\newif\if@titlepage


% class option conditionals
\newif\ifCLASSOPTIONonecolumn       \CLASSOPTIONonecolumnfalse
\newif\ifCLASSOPTIONtwocolumn       \CLASSOPTIONtwocolumntrue

\newif\ifCLASSOPTIONoneside         \CLASSOPTIONonesidetrue
\newif\ifCLASSOPTIONtwoside         \CLASSOPTIONtwosidefalse

\newif\ifCLASSOPTIONfinal           \CLASSOPTIONfinaltrue
\newif\ifCLASSOPTIONdraft           \CLASSOPTIONdraftfalse
\newif\ifCLASSOPTIONdraftcls        \CLASSOPTIONdraftclsfalse
\newif\ifCLASSOPTIONdraftclsnofoot  \CLASSOPTIONdraftclsnofootfalse

\newif\ifCLASSOPTIONpeerreview      \CLASSOPTIONpeerreviewfalse
\newif\ifCLASSOPTIONpeerreviewca    \CLASSOPTIONpeerreviewcafalse

\newif\ifCLASSOPTIONjournal         \CLASSOPTIONjournaltrue
\newif\ifCLASSOPTIONconference      \CLASSOPTIONconferencefalse
\newif\ifCLASSOPTIONtechnote        \CLASSOPTIONtechnotefalse

\newif\ifCLASSOPTIONnofonttune      \CLASSOPTIONnofonttunefalse

\newif\ifCLASSOPTIONcaptionsoff     \CLASSOPTIONcaptionsofffalse

\newif\ifCLASSOPTIONcompsoc         \CLASSOPTIONcompsocfalse

\newif\ifCLASSOPTIONromanappendices \CLASSOPTIONromanappendicesfalse


% class info conditionals

% indicates if pdf (via pdflatex) output
\newif\ifCLASSINFOpdf               \CLASSINFOpdffalse


\newif\if@CEMusingAfourpaper       \@CEMusingAfourpaperfalse



% CEMconf class scratch pad registers
% dimen
\newdimen\@CEMconftmpdimenA
\newdimen\@CEMconftmpdimenB
% count
\newcount\@CEMconftmpcountA
\newcount\@CEMconftmpcountB
% token list
\newtoks\@CEMconftmptoksA

% we use \CLASSOPTIONpt so that we can ID the point size (even for 9pt docs)
% as well as LaTeX's \@ptsize to retain some compatability with some
% external packages
\def\@ptsize{0}
% LaTeX does not support 9pt, so we set \@ptsize to 0 - same as that of 10pt
\DeclareOption{9pt}{\def\CLASSOPTIONpt{9}\def\@ptsize{0}}
\DeclareOption{10pt}{\def\CLASSOPTIONpt{10}\def\@ptsize{0}}
\DeclareOption{11pt}{\def\CLASSOPTIONpt{11}\def\@ptsize{1}}
\DeclareOption{12pt}{\def\CLASSOPTIONpt{12}\def\@ptsize{2}}



%\DeclareOption{letterpaper}{\setlength{\paperheight}{11in}%
%                            \setlength{\paperwidth}{8.5in}%
%                            \@CEMusingAfourpaperfalse
%                            \def\CLASSOPTIONpaper{letter}%
%                            \def\CLASSINFOpaperwidth{8.5in}%
%                            \def\CLASSINFOpaperheight{11in}}


\DeclareOption{a4paper}{\setlength{\paperheight}{297mm}%
                        \setlength{\paperwidth}{210mm}%
                        \@CEMusingAfourpapertrue
                        \def\CLASSOPTIONpaper{a4}%
                        \def\CLASSINFOpaperwidth{210mm}%
                        \def\CLASSINFOpaperheight{297mm}}

\DeclareOption{oneside}{\@twosidefalse\@mparswitchfalse
                        \CLASSOPTIONonesidetrue\CLASSOPTIONtwosidefalse}
\DeclareOption{twoside}{\@twosidetrue\@mparswitchtrue
                        \CLASSOPTIONtwosidetrue\CLASSOPTIONonesidefalse}

\DeclareOption{onecolumn}{\CLASSOPTIONonecolumntrue\CLASSOPTIONtwocolumnfalse}
\DeclareOption{twocolumn}{\CLASSOPTIONtwocolumntrue\CLASSOPTIONonecolumnfalse}

% If the user selects draft, then this class AND any packages
% will go into draft mode.
\DeclareOption{draft}{\CLASSOPTIONdrafttrue\CLASSOPTIONdraftclstrue
                      \CLASSOPTIONdraftclsnofootfalse} 
% draftcls is for a draft mode which will not affect any packages
% used by the document.
\DeclareOption{draftcls}{\CLASSOPTIONdraftfalse\CLASSOPTIONdraftclstrue
                         \CLASSOPTIONdraftclsnofootfalse} 
% draftclsnofoot is like draftcls, but without the footer.
\DeclareOption{draftclsnofoot}{\CLASSOPTIONdraftfalse\CLASSOPTIONdraftclstrue
                               \CLASSOPTIONdraftclsnofoottrue} 
\DeclareOption{final}{\CLASSOPTIONdraftfalse\CLASSOPTIONdraftclsfalse
                      \CLASSOPTIONdraftclsnofootfalse}

\DeclareOption{journal}{\CLASSOPTIONpeerreviewfalse\CLASSOPTIONpeerreviewcafalse
                        \CLASSOPTIONjournaltrue\CLASSOPTIONconferencefalse\CLASSOPTIONtechnotefalse}

\DeclareOption{conference}{\CLASSOPTIONpeerreviewfalse\CLASSOPTIONpeerreviewcafalse
                           \CLASSOPTIONjournalfalse\CLASSOPTIONconferencetrue\CLASSOPTIONtechnotefalse}

\DeclareOption{technote}{\CLASSOPTIONpeerreviewfalse\CLASSOPTIONpeerreviewcafalse
                         \CLASSOPTIONjournalfalse\CLASSOPTIONconferencefalse\CLASSOPTIONtechnotetrue}

\DeclareOption{peerreview}{\CLASSOPTIONpeerreviewtrue\CLASSOPTIONpeerreviewcafalse
                           \CLASSOPTIONjournalfalse\CLASSOPTIONconferencefalse\CLASSOPTIONtechnotefalse}

\DeclareOption{peerreviewca}{\CLASSOPTIONpeerreviewtrue\CLASSOPTIONpeerreviewcatrue
                             \CLASSOPTIONjournalfalse\CLASSOPTIONconferencefalse\CLASSOPTIONtechnotefalse}

\DeclareOption{nofonttune}{\CLASSOPTIONnofonttunetrue}

\DeclareOption{captionsoff}{\CLASSOPTIONcaptionsofftrue}

\DeclareOption{compsoc}{\CLASSOPTIONcompsoctrue}

\DeclareOption{romanappendices}{\CLASSOPTIONromanappendicestrue}


% default to US letter paper, 10pt, twocolumn, one sided, final, journal
\ExecuteOptions{letterpaper,10pt,twocolumn,oneside,final,journal}
% overrride these defaults per user requests
\ProcessOptions


\long\def\@CEMcompsoconly#1{\relax\ifCLASSOPTIONcompsoc\relax#1\relax\fi\relax}
% inverse
\long\def\@CEMnotcompsoconly#1{\relax\ifCLASSOPTIONcompsoc\else\relax#1\relax\fi\relax}
% compsoc conference
\long\def\@CEMcompsocconfonly#1{\relax\ifCLASSOPTIONcompsoc\ifCLASSOPTIONconference\relax#1\relax\fi\fi\relax}
% compsoc not conference
\long\def\@CEMcompsocnotconfonly#1{\relax\ifCLASSOPTIONcompsoc\ifCLASSOPTIONconference\else\relax#1\relax\fi\fi\relax}


% CEM uses Times Roman font, so we'll default to Times.
% These three commands make up the entire times.sty package.
\renewcommand{\sfdefault}{phv}
\renewcommand{\rmdefault}{ptm}
\renewcommand{\ttdefault}{pcr}

\@CEMcompsoconly{\typeout{-- Using CEM mode.}}

\@CEMcompsocnotconfonly{\renewcommand{\rmdefault}{ppl}}

% enable Times/Palatino main text font
\normalfont\selectfont





% V1.7 conference notice message hook
\def\@CEMconsolenoticeconference{\typeout{}%
\typeout{** Conference Paper **}%
\typeout{Before submitting the final version, remember to:}%
\typeout{}%
\typeout{ 1. Manually equalize the lengths of two columns on the last page}%
\typeout{ of your paper;}%
\typeout{}%
\typeout{ 2. Ensure that any PostScript and/or PDF output post-processing}%
\typeout{ uses only Type 1 fonts and that every step in the generation}%
\typeout{ process uses the appropriate paper size.}%
\typeout{}}


% we can send console reminder messages to the user here
\AtEndDocument{\ifCLASSOPTIONconference\@CEMconsolenoticeconference\fi}


% warn about the use of single column other than for draft mode
\ifCLASSOPTIONtwocolumn\else%
  \ifCLASSOPTIONdraftcls\else%
   \typeout{** ATTENTION: Single column mode is not typically used with CEM publications.}%
  \fi%
\fi

% if \pdfoutput is undefined or equal to relax, output a dvips special
{\@ifundefined{pdfoutput}{\AtBeginDvi{\special{papersize=\CLASSINFOpaperwidth,\CLASSINFOpaperheight}}}{%
% pdfoutput is defined and not equal to \relax
% check for pdfpageheight existence just in case someone sets pdfoutput
% under non-pdflatex. If exists, set them regardless of value of \pdfoutput.
\@ifundefined{pdfpageheight}{\relax}{\global\pdfpagewidth\paperwidth
\global\pdfpageheight\paperheight}%
% if using \pdfoutput=0 under pdflatex, send dvips papersize special
\ifcase\pdfoutput
\AtBeginDvi{\special{papersize=\CLASSINFOpaperwidth,\CLASSINFOpaperheight}}%
\else
% we are using pdf output, set CLASSINFOpdf flag
\global\CLASSINFOpdftrue
\fi}}

% let the user know the selected papersize
\typeout{-- Using \CLASSINFOpaperwidth\space x \CLASSINFOpaperheight\space
(\CLASSOPTIONpaper)\space paper.}

\ifCLASSINFOpdf
\typeout{-- Using PDF output.}
\else
\typeout{-- Using DVI output.}
\fi



% FONT CONTROLS AND SPACINGS FOR CONFERENCE MODE AUTHOR NAME AND AFFILIATION BLOCKS
% 
% The default font styles for the author name and affiliation blocks (confmode)
\def\@CEMauthorblockNstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\sublargesize\@CEMcompsocconfonly{\large}}
\def\@CEMauthorblockAstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\@CEMcompsocconfonly{\itshape}\normalsize\@CEMcompsocconfonly{\large}}
% The default if the user does not use an author block
\def\@CEMauthordefaulttextstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\sublargesize}

% adjustment spacing from title (or special paper notice) to author name blocks (confmode)
% can be negative
\def\@CEMauthorblockconfadjspace{-0.25em}
% compsoc conferences need more space here
\@CEMcompsocconfonly{\def\@CEMauthorblockconfadjspace{0.75\@CEMnormalsizeunitybaselineskip}}

% spacing between name and affiliation blocks (confmode)
% This can be negative.
% CEM doesn't want any added spacing here, but I will leave these
% controls in place in case they ever change their mind.
% Personally, I like 0.75ex.
%\def\@CEMauthorblockNtopspace{0.75ex}
%\def\@CEMauthorblockAtopspace{0.75ex}
\def\@CEMauthorblockNtopspace{0.0ex}
\def\@CEMauthorblockAtopspace{0.0ex}
%\ifCLASSOPTIONtransmag
%% transmag uses one line of space above first affiliation block
%\def\@CEMauthorblockAtopspace{1\@CEMnormalsizeunitybaselineskip}
%\fi

% baseline spacing within name and affiliation blocks (confmode)
% must be positive, spacings below certain values will make 
% the position of line of text sensitive to the contents of the
% line above it i.e., whether or not the prior line has descenders, 
% subscripts, etc. For this reason it is a good idea to keep
% these above 2.6ex
\def\@CEMauthorblockNinterlinespace{2.6ex}
\def\@CEMauthorblockAinterlinespace{2.75ex}

% This tracks the required strut size.
% See the \@CEMauthorhalign command for the actual default value used.
\def\@CEMauthorblockXinterlinespace{2.7ex}









% pointsize values
% used with ifx to determine the document's normal size
\def\@CEMptsizenine{9}
\def\@CEMptsizeten{10}
\def\@CEMptsizeeleven{11}
\def\@CEMptsizetwelve{12}



% FONT DEFINITIONS (No sizexx.clo file needed) 
\newdimen\@CEMnormalsizeunitybaselineskip
\@CEMnormalsizeunitybaselineskip\baselineskip

\ifx\CLASSOPTIONpt\@CEMptsizenine
\typeout{-- This is a 9 point document.}
\def\normalsize{\@setfontsize{\normalsize}{9}{11.0476pt}}%
\setlength{\@CEMnormalsizeunitybaselineskip}{11.0476pt}%
\normalsize
\abovedisplayskip 1.5ex plus3pt minus1pt%
\belowdisplayskip \abovedisplayskip%
\abovedisplayshortskip 0pt plus3pt%
\belowdisplayshortskip 1.5ex plus3pt minus1pt
\def\small{\@setfontsize{\small}{8.5}{10pt}}
\def\footnotesize{\@setfontsize{\footnotesize}{8}{9pt}}
\def\scriptsize{\@setfontsize{\scriptsize}{7}{8pt}}
\def\tiny{\@setfontsize{\tiny}{5}{6pt}}
% sublargesize is the same as large - 10pt
\def\sublargesize{\@setfontsize{\sublargesize}{10}{12pt}}
\def\large{\@setfontsize{\large}{10}{10pt}}
\def\Large{\@setfontsize{\Large}{12}{12pt}}
\def\LARGE{\@setfontsize{\LARGE}{14}{17pt}}
\def\huge{\@setfontsize{\huge}{17}{20pt}}
\def\Huge{\@setfontsize{\Huge}{20}{24pt}}
\fi


% Check if we have selected 10 points
\ifx\CLASSOPTIONpt\@CEMptsizeten
\typeout{-- This is a 10 point document.}
\def\normalsize{\@setfontsize{\normalsize}{10}{11.50pt}}%
\setlength{\@CEMnormalsizeunitybaselineskip}{12pt}%
\normalsize
\abovedisplayskip 1.5ex plus4pt minus2pt%
\belowdisplayskip \abovedisplayskip%
\abovedisplayshortskip 0pt plus4pt%
\belowdisplayshortskip 1.5ex plus4pt minus2pt
\def\small{\@setfontsize{\small}{9}{10pt}}
\def\footnotesize{\@setfontsize{\footnotesize}{8}{9pt}}
\def\scriptsize{\@setfontsize{\scriptsize}{7}{8pt}}
\def\tiny{\@setfontsize{\tiny}{5}{6pt}}
% sublargesize is a tad smaller than large - 11pt
\def\sublargesize{\@setfontsize{\sublargesize}{11}{13.4pt}}
\def\large{\@setfontsize{\large}{12}{12pt}}
\def\Large{\@setfontsize{\Large}{14}{14pt}}
\def\LARGE{\@setfontsize{\LARGE}{17}{20pt}}
\def\huge{\@setfontsize{\huge}{20}{24pt}}
\def\Huge{\@setfontsize{\Huge}{24}{28pt}}
\fi

% Check if we have selected 11 points
\ifx\CLASSOPTIONpt\@CEMptsizeeleven
\typeout{-- This is an 11 point document.}
\def\normalsize{\@setfontsize{\normalsize}{11}{13.3846pt}}%
\setlength{\@CEMnormalsizeunitybaselineskip}{13.3846pt}%
\normalsize
\abovedisplayskip 1.5ex plus5pt minus3pt%
\belowdisplayskip \abovedisplayskip%
\abovedisplayshortskip 0pt plus5pt%
\belowdisplayshortskip 1.5ex plus5pt minus3pt
\def\small{\@setfontsize{\small}{10}{12pt}}
\def\footnotesize{\@setfontsize{\footnotesize}{9}{10.5pt}}
\def\scriptsize{\@setfontsize{\scriptsize}{8}{9pt}}
\def\tiny{\@setfontsize{\tiny}{6}{7pt}}
% sublargesize is the same as large - 12pt
\def\sublargesize{\@setfontsize{\sublargesize}{12}{14pt}}
\def\large{\@setfontsize{\large}{12}{14pt}}
\def\Large{\@setfontsize{\Large}{14}{17pt}}
\def\LARGE{\@setfontsize{\LARGE}{17}{20pt}}
\def\huge{\@setfontsize{\huge}{20}{24pt}}
\def\Huge{\@setfontsize{\Huge}{24}{28pt}}
\fi


% Check if we have selected 12 points
\ifx\CLASSOPTIONpt\@CEMptsizetwelve
\typeout{-- This is a 12 point document.}
\def\normalsize{\@setfontsize{\normalsize}{12}{13.92pt}}%
\setlength{\@CEMnormalsizeunitybaselineskip}{13.92pt}%
\normalsize
\abovedisplayskip 1.5ex plus6pt minus4pt%
\belowdisplayskip \abovedisplayskip%
\abovedisplayshortskip 0pt plus6pt%
\belowdisplayshortskip 1.5ex plus6pt minus4pt
\def\small{\@setfontsize{\small}{10}{12pt}}
\def\footnotesize{\@setfontsize{\footnotesize}{9}{10.5pt}}
\def\scriptsize{\@setfontsize{\scriptsize}{8}{9pt}}
\def\tiny{\@setfontsize{\tiny}{6}{7pt}}
% sublargesize is the same as large - 14pt
\def\sublargesize{\@setfontsize{\sublargesize}{14}{17pt}}
\def\large{\@setfontsize{\large}{12}{12pt}}
\def\Large{\@setfontsize{\Large}{14}{14pt}}
\def\LARGE{\@setfontsize{\LARGE}{20}{24pt}}
\def\huge{\@setfontsize{\huge}{22}{26pt}}
\def\Huge{\@setfontsize{\Huge}{24}{28pt}}
\fi


% The Computer Modern Fonts will issue a substitution warning for
% 24pt titles (24.88pt is used instead) increase the substitution
% tolerance to turn off this warning
\def\fontsubfuzz{.9pt}
% However, the default (and correct) Times font will scale exactly as needed.


% warn the user in case they forget to use the 9pt option with
% technote
\ifCLASSOPTIONtechnote%
 \ifx\CLASSOPTIONpt\@CEMptsizenine\else%
  \typeout{** ATTENTION: Technotes are normally 9pt documents.}%
 \fi%
\fi

% Improved \textunderscore to provide a much better fake _ when used with
% OT1 encoding. Under OT1, detect use of pcr or cmtt \ttfamily and use
% available true _ glyph for those two typewriter fonts.
\def\@CEMstringptm{ptm} % Times Roman family
\def\@CEMstringppl{ppl} % Palatino Roman family
\def\@CEMstringphv{phv} % Helvetica Sans Serif family
\def\@CEMstringpcr{pcr} % Courier typewriter family
\def\@CEMstringcmtt{cmtt} % Computer Modern typewriter family
\DeclareTextCommandDefault{\textunderscore}{\leavevmode
\ifx\f@family\@CEMstringpcr\string_\else
\ifx\f@family\@CEMstringcmtt\string_\else
\ifx\f@family\@CEMstringptm\kern 0em\vbox{\hrule\@width 0.5em\@height 0.5pt\kern -0.3ex}\else
\ifx\f@family\@CEMstringppl\kern 0em\vbox{\hrule\@width 0.5em\@height 0.5pt\kern -0.3ex}\else
\ifx\f@family\@CEMstringphv\kern -0.03em\vbox{\hrule\@width 0.62em\@height 0.52pt\kern -0.33ex}\kern -0.03em\else
\kern 0.09em\vbox{\hrule\@width 0.6em\@height 0.44pt\kern -0.63pt\kern -0.42ex}\kern 0.09em\fi\fi\fi\fi\fi\relax}


% set the default \baselinestretch
\def\baselinestretch{1}
\ifCLASSOPTIONdraftcls
  \def\baselinestretch{1.5}% default baselinestretch for draft modes
\fi 


% process CLASSINPUT baselinestretch
\ifx\CLASSINPUTbaselinestretch\@CEMundefined
\else
  \edef\baselinestretch{\CLASSINPUTbaselinestretch} % user CLASSINPUT override
  \typeout{** ATTENTION: Overriding \string\baselinestretch\space to
           \baselinestretch\space via \string\CLASSINPUT.}
\fi

\normalsize % make \baselinestretch take affect


% store the normalsize baselineskip
\newdimen\CLASSINFOnormalsizebaselineskip
\CLASSINFOnormalsizebaselineskip=\baselineskip\relax
% and the normalsize unity (baselinestretch=1) baselineskip
% we could save a register by giving the user access to
% \@CEMnormalsizeunitybaselineskip. However, let's protect
% its read only internal status
\newdimen\CLASSINFOnormalsizeunitybaselineskip
\CLASSINFOnormalsizeunitybaselineskip=\@CEMnormalsizeunitybaselineskip\relax
% store the nominal value of jot
\newdimen\CEMnormaljot
\CEMnormaljot=0.25\baselineskip\relax

% set \jot
\jot=\CEMnormaljot\relax




\def\@CEMinterspaceratioM{0.35}
\def\@CEMinterspaceMINratioM{0.23}
\def\@CEMinterspaceMAXratioM{0.50}

% for bold
\def\@CEMinterspaceratioB{0.375}
\def\@CEMinterspaceMINratioB{0.23}
\def\@CEMinterspaceMAXratioB{0.55}


% command to revise the interword spacing for the current font under TeX:
% \fontdimen2 = nominal interword space
% \fontdimen3 = interword stretch
% \fontdimen4 = interword shrink
% since all changes to the \fontdimen are global, we can enclose these commands
% in braces to confine any font attribute or length changes
\def\@@@CEMsetfontdimens#1#2#3{{%
\setlength{\@CEMconftmpdimenB}{\f@size pt}% grab the font size in pt, could use 1em instead.
\setlength{\@CEMconftmpdimenA}{#1\@CEMconftmpdimenB}%
\fontdimen2\font=\@CEMconftmpdimenA\relax
\addtolength{\@CEMconftmpdimenA}{-#2\@CEMconftmpdimenB}%
\fontdimen3\font=-\@CEMconftmpdimenA\relax
\setlength{\@CEMconftmpdimenA}{#1\@CEMconftmpdimenB}%
\addtolength{\@CEMconftmpdimenA}{-#3\@CEMconftmpdimenB}%
\fontdimen4\font=\@CEMconftmpdimenA\relax}}

% revise the interword spacing for each font weight
\def\@@CEMsetfontdimens{{%
\mdseries
\@@@CEMsetfontdimens{\@CEMinterspaceratioM}{\@CEMinterspaceMAXratioM}{\@CEMinterspaceMINratioM}%
\bfseries
\@@@CEMsetfontdimens{\@CEMinterspaceratioB}{\@CEMinterspaceMAXratioB}{\@CEMinterspaceMINratioB}%
}}

% revise the interword spacing for each font shape
% \slshape is not often used for CEM work and is not altered here. The \scshape caps are
% already a tad too large in the free LaTeX fonts (as compared to what CEM uses) so we
% won't alter these either.
\def\@CEMsetfontdimens{{%
\normalfont
\@@CEMsetfontdimens
\normalfont\itshape
\@@CEMsetfontdimens
}}

% command to revise the interword spacing for each font size (and shape
% and weight). Only the \rmfamily is done here as \ttfamily uses a 
% fixed spacing and \sffamily is not used as the main text of CEM papers.
\def\@CEMtunefonts{{\selectfont\rmfamily
\tiny\@CEMsetfontdimens
\scriptsize\@CEMsetfontdimens
\footnotesize\@CEMsetfontdimens
\small\@CEMsetfontdimens
\normalsize\@CEMsetfontdimens
\sublargesize\@CEMsetfontdimens
\large\@CEMsetfontdimens
\LARGE\@CEMsetfontdimens
\huge\@CEMsetfontdimens
\Huge\@CEMsetfontdimens}}

% if the nofonttune class option is not given, revise the interword spacing
% now - in case CEMconf makes any default length measurements, and make
% sure all the default fonts are loaded
\ifCLASSOPTIONnofonttune\else
\@CEMtunefonts
\fi

% and again at the start of the document in case the user loaded different fonts
\AtBeginDocument{\ifCLASSOPTIONnofonttune\else\@CEMtunefonts\fi}


\hyphenpenalty=750
% If we didn't adjust the interword spacing, 2200 might be better.
% The TeX default is 1000
\hbadness=1350
% CEM does not use extra spacing after punctuation
\frenchspacing

% V1.7 increase this a tad to discourage equation breaks
\binoppenalty=1000 % default 700
\relpenalty=800     % default 500


% margin note stuff
\marginparsep      10pt
\marginparwidth    20pt
\marginparpush     25pt


% if things get too close, go ahead and let them touch
\lineskip            0pt
\normallineskip      0pt
\lineskiplimit       0pt
\normallineskiplimit 0pt

% The distance from the lower edge of the text body to the
% footline
\footskip 0.4in

% normally zero, should be relative to font height.
% put in a little rubber to help stop some bad breaks (underfull vboxes)
\parskip 0ex plus 0.2ex minus 0.1ex

\parindent    1.0em

%\topmargin    -49.0pt
%\headheight   1.18in %12pt
%\footheight   0.98in %12pt
%\headsep      0.25in

\setlength{\columnsep}{0.24in}
\columnwidth 3.23in

% use the normal font baselineskip
% so that \topskip is unaffected by changes in \baselinestretch
\topskip=\@CEMnormalsizeunitybaselineskip
\textheight       58pc  % 9.63in, 696pt
% Tweak textheight to a perfect integer number of lines/page.
% The normal baselineskip for each document point size is used 
% to determine these values.
\ifx\CLASSOPTIONpt\@CEMptsizenine\textheight=63\@CEMnormalsizeunitybaselineskip\fi      % 63 lines/page
\ifx\CLASSOPTIONpt\@CEMptsizeten\textheight=58\@CEMnormalsizeunitybaselineskip\fi       % 58 lines/page
\ifx\CLASSOPTIONpt\@CEMptsizeeleven\textheight=52\@CEMnormalsizeunitybaselineskip\fi    % 52 lines/page
\ifx\CLASSOPTIONpt\@CEMptsizetwelve\textheight=50\@CEMnormalsizeunitybaselineskip\fi    % 50 lines/page


%\columnsep         1pc
\columnsep         0.65cm %0.75cm
\textwidth        43pc   % 2 x 21pc + 1pc = 43pc
 

% the default side margins are equal
\if@CEMusingAfourpaper 
\oddsidemargin        14.32mm
\evensidemargin       14.32mm
\else
\oddsidemargin        0.680in
\evensidemargin       0.680in
\fi
% compensate for LaTeX's 1in offset
\addtolength{\oddsidemargin}{-1in}
\addtolength{\evensidemargin}{-1in}



% adjust margins for conference mode
\ifCLASSOPTIONconference
 \topmargin        -0.25in
 % we retain the reserved, but unused space for headers
 \addtolength{\topmargin}{-\headheight}
 \addtolength{\topmargin}{-\headsep}
 \textheight        9.25in % The standard for conferences (668.4975pt)
 % Tweak textheight to a perfect integer number of lines/page.
 \ifx\CLASSOPTIONpt\@CEMptsizenine\textheight=61\@CEMnormalsizeunitybaselineskip\fi      % 61 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizeten\textheight=56\@CEMnormalsizeunitybaselineskip\fi       % 56 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizeeleven\textheight=50\@CEMnormalsizeunitybaselineskip\fi    % 50 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizetwelve\textheight=48\@CEMnormalsizeunitybaselineskip\fi    % 48 lines/page
\fi


% compsoc conference
\ifCLASSOPTIONcompsoc
\ifCLASSOPTIONconference
 % compsoc conference use a larger value for columnsep
 \columnsep 0.24in
 % compsoc conferences want 1in top margin, 1.125in bottom margin
 \topmargin        0in
 \addtolength{\topmargin}{-6pt}% we tweak this a tad to better comply with top of line stuff
 % we retain the reserved, but unused space for headers
 \addtolength{\topmargin}{-\headheight}
 \addtolength{\topmargin}{-\headsep}
 \textheight        8.875in % (641.39625pt)
 % Tweak textheight to a perfect integer number of lines/page.
 \ifx\CLASSOPTIONpt\@CEMptsizenine\textheight=58\@CEMnormalsizeunitybaselineskip\fi      % 58 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizeten\textheight=53\@CEMnormalsizeunitybaselineskip\fi       % 53 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizeeleven\textheight=48\@CEMnormalsizeunitybaselineskip\fi    % 48 lines/page
 \ifx\CLASSOPTIONpt\@CEMptsizetwelve\textheight=46\@CEMnormalsizeunitybaselineskip\fi    % 46 lines/page 
 \textwidth 6.5in
 % the default side margins are equal
 \if@CEMusingAfourpaper 
  \oddsidemargin        22.45mm
  \evensidemargin       22.45mm
 \else
  \oddsidemargin        1in
  \evensidemargin       1in
 \fi
 % compensate for LaTeX's 1in offset
 \addtolength{\oddsidemargin}{-1in}
 \addtolength{\evensidemargin}{-1in}
\fi\fi



% draft mode settings override that of all other modes
% provides a nice 1in margin all around the paper and extra
% space between the lines for editor's comments
\ifCLASSOPTIONdraftcls 
  % want 1in from top of paper to text
  \setlength{\topmargin}{-\headsep}%
  \addtolength{\topmargin}{-\headheight}%
  % we want 1in side margins regardless of paper type
  \oddsidemargin      0in
  \evensidemargin     0in
  % set the text width
  \setlength{\textwidth}{\paperwidth}%
  \addtolength{\textwidth}{-2.0in}%
  \setlength{\textheight}{\paperheight}%
  \addtolength{\textheight}{-2.0in}%
  % digitize textheight to be an integer number of lines.
  % this may cause the bottom margin to be off a tad
  \addtolength{\textheight}{-1\topskip}%
  \divide\textheight  by \baselineskip%
  \multiply\textheight  by \baselineskip%
  \addtolength{\textheight}{\topskip}%
\fi



% process CLASSINPUT inner/outer margin
% if inner margin defined, but outer margin not, set outer to inner.
\ifx\CLASSINPUTinnersidemargin\@CEMundefined
\else
  \ifx\CLASSINPUToutersidemargin\@CEMundefined
    \edef\CLASSINPUToutersidemargin{\CLASSINPUTinnersidemargin}
  \fi
\fi

\ifx\CLASSINPUToutersidemargin\@CEMundefined
\else
  % if outer margin defined, but inner margin not, set inner to outer.
  \ifx\CLASSINPUTinnersidemargin\@CEMundefined
    \edef\CLASSINPUTinnersidemargin{\CLASSINPUToutersidemargin}
  \fi
  \setlength{\oddsidemargin}{\CLASSINPUTinnersidemargin}
  \ifCLASSOPTIONtwoside
    \setlength{\evensidemargin}{\CLASSINPUToutersidemargin}
  \else
    \setlength{\evensidemargin}{\CLASSINPUTinnersidemargin}
  \fi
  \addtolength{\oddsidemargin}{-1in}
  \addtolength{\evensidemargin}{-1in}
  \setlength{\textwidth}{\paperwidth}
  \addtolength{\textwidth}{-\CLASSINPUTinnersidemargin}
  \addtolength{\textwidth}{-\CLASSINPUToutersidemargin}
  \typeout{** ATTENTION: Overriding inner side margin to \CLASSINPUTinnersidemargin\space and 
           outer side margin to \CLASSINPUToutersidemargin\space via \string\CLASSINPUT.}
\fi



% process CLASSINPUT top/bottom text margin
% if toptext margin defined, but bottomtext margin not, set bottomtext to toptext margin
\ifx\CLASSINPUTtoptextmargin\@CEMundefined
\else
  \ifx\CLASSINPUTbottomtextmargin\@CEMundefined
    \edef\CLASSINPUTbottomtextmargin{\CLASSINPUTtoptextmargin}
  \fi
\fi

\ifx\CLASSINPUTbottomtextmargin\@CEMundefined
\else
  % if bottomtext margin defined, but toptext margin not, set toptext to bottomtext margin
  \ifx\CLASSINPUTtoptextmargin\@CEMundefined
    \edef\CLASSINPUTtoptextmargin{\CLASSINPUTbottomtextmargin}
  \fi
  \setlength{\topmargin}{\CLASSINPUTtoptextmargin}
  \addtolength{\topmargin}{-1in}
  \addtolength{\topmargin}{-\headheight}
  \addtolength{\topmargin}{-\headsep}
  \setlength{\textheight}{\paperheight}
  \addtolength{\textheight}{-\CLASSINPUTtoptextmargin}
  \addtolength{\textheight}{-\CLASSINPUTbottomtextmargin}
  % in the default format we use the normal baselineskip as topskip
  % we only need 0.7 of this to clear typical top text and we need
  % an extra 0.3 spacing at the bottom for descenders. This will
  % correct for both.
  \addtolength{\topmargin}{-0.3\@CEMnormalsizeunitybaselineskip}
  \typeout{** ATTENTION: Overriding top text margin to \CLASSINPUTtoptextmargin\space and 
           bottom text margin to \CLASSINPUTbottomtextmargin\space via \string\CLASSINPUT.}
\fi







% LIST SPACING CONTROLS

% Controls the amount of EXTRA spacing
% above and below \trivlist 
% Both \list and IED lists override this.
% However, \trivlist will use this as will most
% things built from \trivlist like the \center
% environment.
\topsep           0.5\baselineskip

% Controls the additional spacing around lists preceded
% or followed by blank lines. CEM does not increase
% spacing before or after paragraphs so it is set to zero.
% \z@ is the same as zero, but faster.
\partopsep          \z@

% Controls the spacing between paragraphs in lists. 
% CEM does not increase spacing before or after paragraphs
% so this is also zero. 
% With CEMconf.cls, global changes to
% this value DO affect lists (but not IED lists).
\parsep             \z@

% Controls the extra spacing between list items. 
% CEM does not put extra spacing between items.
% With CEMconf.cls, global changes to this value DO affect
% lists (but not IED lists).
\itemsep            \z@

% \itemindent is the amount to indent the FIRST line of a list
% item. It is auto set to zero within the \list environment. To alter
% it, you have to do so when you call the \list.
% However, CEM uses this for the theorem environment
% There is an alternative value for this near \leftmargini below
\itemindent         -1em

% \leftmargin, the spacing from the left margin of the main text to
% the left of the main body of a list item is set by \list.
% Hence this statement does nothing for lists.
% But, quote and verse do use it for indention.
\leftmargin         2em

% we retain this stuff from the older CEMconf.cls so that \list
% will work the same way as before. However, itemize, enumerate and
% description (IED) could care less about what these are as they
% all are overridden.
\leftmargini        2em
%\itemindent         2em  % Alternative values: sometimes used.
%\leftmargini        0em
\leftmarginii       1em
\leftmarginiii    1.5em
\leftmarginiv     1.5em
\leftmarginv      1.0em
\leftmarginvi     1.0em
\labelsep         0.5em 
\labelwidth         \z@


 
\def\@listi{\leftmargin\leftmargini \topsep 2pt plus 1pt minus 1pt}
\let\@listI\@listi
\def\@listii{\leftmargin\leftmarginii\labelwidth\leftmarginii%
    \advance\labelwidth-\labelsep \topsep 2pt}
\def\@listiii{\leftmargin\leftmarginiii\labelwidth\leftmarginiii%
    \advance\labelwidth-\labelsep \topsep 2pt}
\def\@listiv{\leftmargin\leftmarginiv\labelwidth\leftmarginiv%
    \advance\labelwidth-\labelsep \topsep 2pt}
\def\@listv{\leftmargin\leftmarginv\labelwidth\leftmarginv%
    \advance\labelwidth-\labelsep \topsep 2pt}
\def\@listvi{\leftmargin\leftmarginvi\labelwidth\leftmarginvi%
    \advance\labelwidth-\labelsep \topsep 2pt}


% CEM uses 5) not 5.
\def\labelenumi{\theenumi)}     \def\theenumi{\arabic{enumi}}

% CEM uses a) not (a)
\def\labelenumii{\theenumii)}  \def\theenumii{\alph{enumii}}

% CEM uses iii) not iii.
\def\labelenumiii{\theenumiii)} \def\theenumiii{\roman{enumiii}}

% CEM uses A) not A.
\def\labelenumiv{\theenumiv)}   \def\theenumiv{\Alph{enumiv}}

% exactly the same as in article.cls
\def\p@enumii{\theenumi}
\def\p@enumiii{\theenumi(\theenumii)}
\def\p@enumiv{\p@enumiii\theenumiii}

% itemized list label styles
\def\labelitemii{$\scriptstyle\bullet$}
%\def\labelitemi{\textbf{--}}
\def\labelitemi{--}
\def\labelitemiii{$\ast$}
\def\labelitemiv{$\cdot$}



\newdimen\CEMilabelindentA
\CEMilabelindentA \parindent

\newdimen\CEMilabelindentB
\CEMilabelindentB 1.3\parindent
% However, we'll default to using \parindent
% which makes more sense to me
\newdimen\CEMilabelindent
\CEMilabelindent \CEMilabelindentA


% This controls the default amount the enumerated list labels
% are indented to the right.
% Normally, this is the same as the paragraph indention
\newdimen\CEMelabelindent
\CEMelabelindent \parindent

% This controls the default amount the description list labels
% are indented to the right.
% Normally, this is the same as the paragraph indention
\newdimen\CEMdlabelindent
\CEMdlabelindent \parindent

% This is the value actually used within the IED lists.
% The IED environments automatically set its value to
% one of the three values above, so global changes do 
% not have any effect
\newdimen\CEMlabelindent
\CEMlabelindent \parindent

% The actual amount labels will be indented is
% \CEMlabelindent multiplied by the factor below
% corresponding to the level of nesting depth
% This provides a means by which the user can
% alter the effective \CEMlabelindent for deeper
% levels
% There may not be such a thing as correct "standard CEM"
% values. What CEM actually does may depend on the specific
% circumstances.
% The first list level almost always has full indention.
% The second levels I've seen have only 75% of the normal indentation
% Three level or greater nestings are very rare. I am guessing
% that they don't use any indentation.
\def\CEMlabelindentfactori{1.0}   % almost always one
\def\CEMlabelindentfactorii{0.75} % 0.0 or 1.0 may be used in some cases
\def\CEMlabelindentfactoriii{0.0} % 0.75? 0.5? 0.0?
\def\CEMlabelindentfactoriv{0.0}
\def\CEMlabelindentfactorv{0.0}
\def\CEMlabelindentfactorvi{0.0}

% value actually used within IED lists, it is auto
% set to one of the 6 values above
% global changes here have no effect
\def\CEMlabelindentfactor{1.0}

% This controls the default spacing between the end of the IED
% list labels and the list text, when normal text is used for
% the labels.
\newdimen\CEMiednormlabelsep
\CEMiednormlabelsep 0.6em

% This controls the default spacing between the end of the IED
% list labels and the list text, when math symbols are used for
% the labels (nomenclature lists). CEM usually increases the 
% spacing in these cases
\newdimen\CEMiedmathlabelsep
\CEMiedmathlabelsep 1.2em

% This controls the extra vertical separation put above and
% below each IED list. CEM usually puts a little extra spacing
% around each list. However, this spacing is barely noticeable.
\newskip\CEMiedtopsep
\CEMiedtopsep 2pt plus 1pt minus 1pt


% This command is executed within each IED list environment
% at the beginning of the list. You can use this to set the 
% parameters for some/all your IED list(s) without disturbing 
% global parameters that affect things other than lists.
% i.e., renewcommand{\CEMiedlistdecl}{\setlength{\labelsep}{5em}}
% will alter the \labelsep for the next list(s) until 
% \CEMiedlistdecl is redefined. 
\def\CEMiedlistdecl{\relax}

% This command provides an easy way to set \leftmargin based
% on the \labelwidth, \labelsep and the argument \CEMlabelindent
% Usage: \CEMcalcleftmargin{width-to-indent-the-label}
% output is in the \leftmargin variable, i.e., effectively:
% \leftmargin = argument + \labelwidth + \labelsep
% Note controlled spacing here, shield end of lines with %
\def\CEMcalcleftmargin#1{\setlength{\leftmargin}{#1}%
\addtolength{\leftmargin}{\labelwidth}%
\addtolength{\leftmargin}{\labelsep}}

% This command provides an easy way to set \labelwidth to the
% width of the given text. It is the same as
% \settowidth{\labelwidth}{label-text}
% and useful as a shorter alternative.
% Typically used to set \labelwidth to be the width
% of the longest label in the list
\def\CEMsetlabelwidth#1{\settowidth{\labelwidth}{#1}}

% When this command is executed, IED lists will use the 
% CEMiedmathlabelsep label separation rather than the normal
% spacing. To have an effect, this command must be executed via
% the \CEMiedlistdecl or within the option of the IED list
% environments.
\def\CEMusemathlabelsep{\setlength{\labelsep}{\CEMiedmathlabelsep}}

% A flag which controls whether the IED lists automatically
% calculate \leftmargin from \CEMlabelindent, \labelwidth and \labelsep
% Useful if you want to specify your own \leftmargin
% This flag must be set (\CEMnocalcleftmargintrue or \CEMnocalcleftmarginfalse) 
% via the \CEMiedlistdecl or within the option of the IED list
% environments to have an effect.
\newif\ifCEMnocalcleftmargin
\CEMnocalcleftmarginfalse

% A flag which controls whether \CEMlabelindent is multiplied by
% the \CEMlabelindentfactor for each list level.
% This flag must be set via the \CEMiedlistdecl or within the option 
% of the IED list environments to have an effect.
\newif\ifCEMnolabelindentfactor
\CEMnolabelindentfactorfalse


% internal variable to indicate type of IED label
% justification
% 0 - left; 1 - center; 2 - right
\def\@CEMiedjustify{0}


% commands to allow the user to control IED
% label justifications. Use these commands within
% the IED environment option or in the \CEMiedlistdecl
% Note that changing the normal list justifications
% is nonstandard and CEM may not like it if you do so!
% I include these commands as they may be helpful to
% those who are using these enhanced list controls for
% other non-CEM related LaTeX work.
% itemize and enumerate automatically default to right
% justification, description defaults to left.
\def\CEMiedlabeljustifyl{\def\@CEMiedjustify{0}}%left
\def\CEMiedlabeljustifyc{\def\@CEMiedjustify{1}}%center
\def\CEMiedlabeljustifyr{\def\@CEMiedjustify{2}}%right




% commands to save to and restore from the list parameter copies
% this allows us to set all the list parameters within
% the list_decl and prevent \list (and its \@list) 
% from overriding any of our parameters
% V1.6 use \edefs instead of dimen's to conserve dimen registers
% Note controlled spacing here, shield end of lines with %
\def\@CEMsavelistparams{\edef\@CEMiedtopsep{\the\topsep}%
\edef\@CEMiedlabelwidth{\the\labelwidth}%
\edef\@CEMiedlabelsep{\the\labelsep}%
\edef\@CEMiedleftmargin{\the\leftmargin}%
\edef\@CEMiedpartopsep{\the\partopsep}%
\edef\@CEMiedparsep{\the\parsep}%
\edef\@CEMieditemsep{\the\itemsep}%
\edef\@CEMiedrightmargin{\the\rightmargin}%
\edef\@CEMiedlistparindent{\the\listparindent}%
\edef\@CEMieditemindent{\the\itemindent}}

% Note controlled spacing here
\def\@CEMrestorelistparams{\topsep\@CEMiedtopsep\relax%
\labelwidth\@CEMiedlabelwidth\relax%
\labelsep\@CEMiedlabelsep\relax%
\leftmargin\@CEMiedleftmargin\relax%
\partopsep\@CEMiedpartopsep\relax%
\parsep\@CEMiedparsep\relax%
\itemsep\@CEMieditemsep\relax%
\rightmargin\@CEMiedrightmargin\relax%
\listparindent\@CEMiedlistparindent\relax%
\itemindent\@CEMieditemindent\relax}


\let\LaTeXitemize\itemize
\let\endLaTeXitemize\enditemize
\let\LaTeXenumerate\enumerate
\let\endLaTeXenumerate\endenumerate

% provide original LaTeX description environment from article.cls
\newenvironment{LaTeXdescription}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                 \normalfont\bfseries #1}


% override LaTeX's default IED lists
\def\itemize{\@CEMitemize}
\def\enditemize{\@endCEMitemize}
\def\enumerate{\@CEMenumerate}
\def\endenumerate{\@endCEMenumerate}
\def\description{\@CEMdescription}
\def\enddescription{\@endCEMdescription}

% provide the user with aliases - may help those using packages that
% override itemize, enumerate, or description
\def\CEMitemize{\@CEMitemize}
\def\endCEMitemize{\@endCEMitemize}
\def\CEMenumerate{\@CEMenumerate}
\def\endCEMenumerate{\@endCEMenumerate}
\def\CEMdescription{\@CEMdescription}
\def\endCEMdescription{\@endCEMdescription}


\def\@CEMitemize{\@ifnextchar[{\@@CEMitemize}{\@@CEMitemize[\relax]}}
\def\@CEMenumerate{\@ifnextchar[{\@@CEMenumerate}{\@@CEMenumerate[\relax]}}
\def\@CEMdescription{\@ifnextchar[{\@@CEMdescription}{\@@CEMdescription[\relax]}}
\def\@endCEMitemize{\endlist}
\def\@endCEMenumerate{\endlist}
\def\@endCEMdescription{\endlist}


\def\@@CEMitemize[#1]{%
                \ifnum\@itemdepth>3\relax\@toodeep\else%
                \ifnum\@listdepth>5\relax\@toodeep\else%
                \advance\@itemdepth\@ne%
                \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
                % get the labelindentfactor for this level
                \advance\@listdepth\@ne% we need to know what the level WILL be
                \edef\CEMlabelindentfactor{\csname CEMlabelindentfactor\romannumeral\the\@listdepth\endcsname}%
                \advance\@listdepth-\@ne% undo our increment
                \def\@CEMiedjustify{2}% right justified labels are default
                % set other defaults
                \CEMnocalcleftmarginfalse%
                \CEMnolabelindentfactorfalse%
                \topsep\CEMiedtopsep%
                \CEMlabelindent\CEMilabelindent%
                \labelsep\CEMiednormlabelsep%
                \partopsep 0ex%
                \parsep 0ex%
                \itemsep 3pt%
                \rightmargin 0em%
                \listparindent 0em%
                \itemindent 0em%
                % calculate the label width
                % the user can override this later if
                % they specified a \labelwidth
                \settowidth{\labelwidth}{\csname labelitem\romannumeral\the\@itemdepth\endcsname}%
                \@CEMsavelistparams% save our list parameters
                \list{\csname\@itemitem\endcsname}{%
                \@CEMrestorelistparams% override any list{} changes
                                       % to our globals
                \let\makelabel\@CEMiedmakelabel% v1.6b setup \makelabel
                \CEMiedlistdecl% let user alter parameters
                #1\relax%
                % If the user has requested not to use the
                % labelindent factor, don't revise \labelindent
                \ifCEMnolabelindentfactor\relax%
                \else\CEMlabelindent=\CEMlabelindentfactor\labelindent%
                \fi%
                % Unless the user has requested otherwise,
                % calculate our left margin based
                % on \CEMlabelindent, \labelwidth and
                % \labelsep
                \ifCEMnocalcleftmargin\relax%
                \else\CEMcalcleftmargin{\CEMlabelindent}%
                \fi}\fi\fi}%


\def\@@CEMenumerate[#1]{%
                \ifnum\@enumdepth>3\relax\@toodeep\else%
                \ifnum\@listdepth>5\relax\@toodeep\else%
                \advance\@enumdepth\@ne%
                \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
                % get the labelindentfactor for this level
                \advance\@listdepth\@ne% we need to know what the level WILL be
                \edef\CEMlabelindentfactor{\csname CEMlabelindentfactor\romannumeral\the\@listdepth\endcsname}%
                \advance\@listdepth-\@ne% undo our increment
                \def\@CEMiedjustify{2}% right justified labels are default
                % set other defaults
                \CEMnocalcleftmarginfalse%
                \CEMnolabelindentfactorfalse%
                \topsep\CEMiedtopsep%
                \CEMlabelindent\CEMelabelindent%
                \labelsep\CEMiednormlabelsep%
                \partopsep 0ex%
                \parsep 0ex%
                \itemsep 0ex%
                \rightmargin 0em%
                \listparindent 0em%
                \itemindent 0em%
                % calculate the label width
                % We'll set it to the width suitable for all labels using
                % normalfont 1) to 9)
                % The user can override this later
                \settowidth{\labelwidth}{9)}%
                \@CEMsavelistparams% save our list parameters
                \list{\csname label\@enumctr\endcsname}{\usecounter{\@enumctr}%
                \@CEMrestorelistparams% override any list{} changes
                                       % to our globals
                \let\makelabel\@CEMiedmakelabel% v1.6b setup \makelabel
                \CEMiedlistdecl% let user alter parameters 
                #1\relax%
                % If the user has requested not to use the
                % CEMlabelindent factor, don't revise \CEMlabelindent
                \ifCEMnolabelindentfactor\relax%
                \else\CEMlabelindent=\CEMlabelindentfactor\CEMlabelindent%
                \fi%
                % Unless the user has requested otherwise,
                % calculate our left margin based
                % on \CEMlabelindent, \labelwidth and
                % \labelsep
                \ifCEMnocalcleftmargin\relax%
                \else\CEMcalcleftmargin{\CEMlabelindent}%
                \fi}\fi\fi}%


\def\@@CEMdescription[#1]{%
                \ifnum\@listdepth>5\relax\@toodeep\else%
                % get the labelindentfactor for this level
                \advance\@listdepth\@ne% we need to know what the level WILL be
                \edef\CEMlabelindentfactor{\csname CEMlabelindentfactor\romannumeral\the\@listdepth\endcsname}%
                \advance\@listdepth-\@ne% undo our increment
                \def\@CEMiedjustify{0}% left justified labels are default
                % set other defaults
                \CEMnocalcleftmarginfalse%
                \CEMnolabelindentfactorfalse%
                \topsep\CEMiedtopsep% 
                \CEMlabelindent\CEMdlabelindent%
                % assume normal labelsep
                \labelsep\CEMiednormlabelsep%
                \partopsep 0ex%
                \parsep 0ex%
                \itemsep 0ex%
                \rightmargin 0em%
                \listparindent 0em%
                \itemindent 0em%
                % Bogus label width in case the user forgets
                % to set it.
                % TIP: If you want to see what a variable's width is you
                % can use the TeX command \showthe\width-variable to 
                % display it on the screen during compilation 
                % (This might be helpful to know when you need to find out
                % which label is the widest)
                \settowidth{\labelwidth}{Hello}%
                \@CEMsavelistparams% save our list parameters
                \list{}{\@CEMrestorelistparams% override any list{} changes
                                               % to our globals
                \let\makelabel\@CEMiedmakelabel% v1.6b setup \makelabel
                \CEMiedlistdecl% let user alter parameters 
                #1\relax%
                % If the user has requested not to use the
                % labelindent factor, don't revise \CEMlabelindent
                \ifCEMnolabelindentfactor\relax%
                \else\CEMlabelindent=\CEMlabelindentfactor\CEMlabelindent%
                \fi%
                % Unless the user has requested otherwise,
                % calculate our left margin based
                % on \CEMlabelindent, \labelwidth and
                % \labelsep
                \ifCEMnocalcleftmargin\relax%
                \else\CEMcalcleftmargin{\CEMlabelindent}\relax%
                \fi}\fi}


\def\@CEMiedmakelabel#1{\relax\if\@CEMiedjustify 0\relax
\makebox[\labelwidth][l]{\normalfont #1}\else
\if\@CEMiedjustify 1\relax
\makebox[\labelwidth][c]{\normalfont #1}\else
\makebox[\labelwidth][r]{\normalfont #1}\fi\fi}


% VERSE and QUOTE
\newenvironment{verse}{\let\\=\@centercr
    \list{}{\itemsep\z@ \itemindent -1.5em \listparindent \itemindent
    \rightmargin\leftmargin\advance\leftmargin 1.5em}\item\relax}
    {\endlist}
\newenvironment{quotation}{\list{}{\listparindent 1.5em \itemindent\listparindent
    \rightmargin\leftmargin \parsep 0pt plus 1pt}\item\relax}
    {\endlist}
\newenvironment{quote}{\list{}{\rightmargin\leftmargin}\item\relax}
    {\endlist}


% \titlepage
% provided only for backward compatibility. \maketitle is the correct
% way to create the title page. 
\newif\if@restonecol
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
    \else \newpage \fi \thispagestyle{empty}\c@page\z@}
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}

% standard values from article.cls
\arraycolsep     5pt
\arrayrulewidth .4pt
\doublerulesep   2pt

\tabcolsep       6pt
\tabbingsep      0.5em


%% FOOTNOTES
\skip\footins 0.9\baselineskip  plus 0.4\baselineskip  minus 0.2\baselineskip

{\footnotesize
\global\footnotesep 0.8\baselineskip}


\skip\@mpfootins = \skip\footins
\fboxsep = 3pt
\fboxrule = .4pt
\long\def\@makefntext#1{\parindent 1em\indent\hbox{\@makefnmark}#1}
\ifCLASSOPTIONcompsoc
\def\@CEMcompsocmakefnmark{\hbox{\normalfont\@thefnmark.\ }}
\long\def\@makefntext#1{\parindent 1em\indent\hbox{\@CEMcompsocmakefnmark}#1}
\fi

% CEM does not use footnote rules
\def\footnoterule{}

\newif\if@CEMenableoneshotfootnoterule
\@CEMenableoneshotfootnoterulefalse
\ifCLASSOPTIONcompsoc
\def\footnoterule{\relax\if@CEMenableoneshotfootnoterule
\kern-5pt
\hbox to \columnwidth{\hfill\vrule width 0.5\columnwidth height 0.4pt\hfill}
\kern4.6pt
\global\@CEMenableoneshotfootnoterulefalse
\else
\relax
\fi}
\fi

\interfootnotelinepenalty=10000

\interdisplaylinepenalty=2500

% default allows section depth up to /paragraph
\setcounter{secnumdepth}{4}

% technotes do not allow /paragraph
\ifCLASSOPTIONtechnote
   \setcounter{secnumdepth}{3}
\fi
% neither do compsoc conferences
\@CEMcompsocconfonly{\setcounter{secnumdepth}{3}}


\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]

\newcounter{CEMsubequation}[equation]

% as shown when called by user from \ref, \label and in table of contents
\def\theequation{\arabic{equation}}                          % 1
\def\theCEMsubequation{\theequation\alph{CEMsubequation}}  % 1a (used only by CEMconf's CEMeqnarray)
\ifCLASSOPTIONcompsoc
% compsoc is all arabic
\def\thesection{\arabic{section}}                
\def\thesubsection{\thesection.\arabic{subsection}}
\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
\def\theparagraph{\thesubsubsection.\arabic{paragraph}}
\else
    \def\thesection{\Roman{section}}
    \def\thesubsection{\thesection.\arabic{subsection}}
    \def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
    \def\theparagraph{\thesubsubsection.\arabic{paragraph}}
%\def\thesection{\Roman{section}}                
%\def\thesubsection{\thesection.\arabic{subsection}}
%\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
%\def\theparagraph{\thesubsubsection.\arabic{paragraph}}
%\def\thesection{\Roman{section}}                             % I
%% V1.7, \mbox prevents breaks around - 
%%\def\thesubsection{\mbox{\thesection-\Alph{subsection}}}     % I-A
%\def\thesubsection{\mbox{\Roman{section}.\arabic{subsection}}}     % I.1
%% V1.7 use I-A1 format used by CEM rather than I-A.1
%\def\thesubsubsection{\thesubsection\arabic{subsubsection}}  % I-A1
%\def\theparagraph{\thesubsubsection\alph{paragraph}}         % I-A1a
\fi

\@ifundefined{pdfstringdefPreHook}{\let\pdfstringdefPreHook\@empty}{}%
\g@addto@macro\pdfstringdefPreHook{\let\mbox\relax}


\ifCLASSOPTIONcompsoc
  \ifCLASSOPTIONconference% compsoc conference
    \def\thesectiondis{\thesection.}
    \def\thesubsectiondis{\thesectiondis\arabic{subsection}.}
    \def\thesubsubsectiondis{\thesubsectiondis\arabic{subsubsection}.}
    \def\theparagraphdis{\thesubsubsectiondis\arabic{paragraph}.}
  \else% compsoc not conferencs
    \def\thesectiondis{\thesection}
    \def\thesubsectiondis{\thesectiondis.\arabic{subsection}}
    \def\thesubsubsectiondis{\thesubsectiondis.\arabic{subsubsection}}
    \def\theparagraphdis{\thesubsubsectiondis.\arabic{paragraph}}
  \fi
\else% not compsoc
%%% IMPORTANT
  \def\thesectiondis{{\thesection.}}                   % I.
  \def\thesubsectiondis{{\thesection.\arabic{subsection}.}}          % I.1
  \def\thesubsubsectiondis{\alph{subsubsection} -}  % a - )
\fi

% just like LaTeX2e's \@eqnnum
\def\theequationdis{{\normalfont \normalcolor (\theequation)}}% (1)
% CEMsubequation used only by CEMconf's CEMeqnarray
\def\theCEMsubequationdis{{\normalfont \normalcolor (\theCEMsubequation)}}% (1a)
% redirect LaTeX2e's equation number display and all that depend on
% it, through CEMconf's \theequationdis
\def\@eqnnum{\theequationdis}



\def\contentsname{Table}
\def\listfigurename{Liste des Figures}
\def\listtablename{Liste des Tables}
%\def\refname{R\'ef\'erences}
\def\refname{REFERENCES}
\def\indexname{Index}
\def\figurename{\normalsize{Fig. }}
\def\tablename{\normalsize{Table}}
\@CEMcompsocconfonly{\def\figurename{Figure}\def\tablename{Table}}
\def\partname{Part}
\def\appendixname{Appendix}
\def\abstractname{\normalsize{\textbf{\flushleft{Abstract.}}}}
% CEM specific names
\def\CEMkeywordsname{Index Terms}
\def\CEMproofname{Proof}


% LIST OF FIGURES AND TABLES AND TABLE OF CONTENTS
%
\def\@pnumwidth{1.55em}
\def\@tocrmarg{2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{3}

\def\tableofcontents{\section*{\contentsname}\@starttoc{toc}}
\def\l@section#1#2{\addpenalty{\@secpenalty}\addvspace{1.0em plus 1pt}%
    \@tempdima 2.75em \begingroup \parindent \z@ \rightskip \@pnumwidth%
    \parfillskip-\@pnumwidth {\bfseries\leavevmode #1}\hfil\hbox to\@pnumwidth{\hss #2}\par%
    \endgroup}
% argument format #1:level, #2:labelindent,#3:labelsep
\def\l@subsection{\@dottedtocline{2}{2.75em}{3.75em}}
\def\l@subsubsection{\@dottedtocline{3}{6.5em}{4.5em}}
% must provide \l@ defs for ALL sublevels EVEN if tocdepth
% is such as they will not appear in the table of contents
% these defs are how TOC knows what level these things are!
\def\l@paragraph{\@dottedtocline{4}{6.5em}{5.5em}}
\def\l@subparagraph{\@dottedtocline{5}{6.5em}{6.5em}}
\def\listoffigures{\section*{\listfigurename}\@starttoc{lof}}
\def\l@figure{\@dottedtocline{1}{0em}{2.75em}}
\def\listoftables{\section*{\listtablename}\@starttoc{lot}}
\let\l@table\l@figure


%% Definitions for floats
%%
%% Normal Floats
\floatsep 1\baselineskip plus  0.2\baselineskip minus  0.2\baselineskip
\textfloatsep 1.7\baselineskip plus  0.2\baselineskip minus  0.4\baselineskip
\@fptop 0pt plus 1fil
\@fpsep 0.75\baselineskip plus 2fil 
\@fpbot 0pt plus 1fil
\def\topfraction{0.9}
\def\bottomfraction{0.4}
\def\floatpagefraction{0.8}
\def\textfraction{0.1}

%% Double Column Floats
\dblfloatsep 1\baselineskip plus  0.2\baselineskip minus  0.2\baselineskip

\dbltextfloatsep 1.7\baselineskip plus  0.2\baselineskip minus  0.4\baselineskip

\@dblfptop 0pt plus 1fil
\@dblfpsep 0.75\baselineskip plus 2fil
\@dblfpbot 0pt plus 1fil
\def\dbltopfraction{0.8}
\def\dblfloatpagefraction{0.8}
\setcounter{dbltopnumber}{4}

\intextsep 1\baselineskip plus 0.2\baselineskip minus  0.2\baselineskip
\setcounter{topnumber}{2}
\setcounter{bottomnumber}{2}
\setcounter{totalnumber}{4}


\newlength\abovecaptionskip
\newlength\belowcaptionskip
% but only \abovecaptionskip is used above figure captions and *below* table
% captions
\setlength\abovecaptionskip{0.5\baselineskip}
\setlength\belowcaptionskip{0pt}
% V1.6 create hooks in case the caption spacing ever needs to be
% overridden by a user
\def\@CEMfigurecaptionsepspace{\vskip\abovecaptionskip\relax}%
\def\@CEMtablecaptionsepspace{\vskip\abovecaptionskip\relax}%


\def\@CEMtablestring{table}

\ifCLASSOPTIONcompsoc

\ifCLASSOPTIONconference% compsoc conference
\long\def\@makecaption#1#2{%
% test if is a for a figure or table
\ifx\@captype\@CEMtablestring%
% if a table, do table caption
\normalsize\begin{center}{\normalfont\sffamily\normalsize {#1.}~ #2}\end{center}%
\@CEMtablecaptionsepspace
% if not a table, format it as a figure
\else
\@CEMfigurecaptionsepspace
\setbox\@tempboxa\hbox{\normalfont\sffamily\normalsize {#1.}~ #2}%
\ifdim \wd\@tempboxa >\hsize%
% if caption is longer than a line, let it wrap around
\setbox\@tempboxa\hbox{\normalfont\sffamily\normalsize {#1.}~ }%
\parbox[t]{\hsize}{\normalfont\sffamily\normalsize \noindent\unhbox\@tempboxa#2}%
% if caption is shorter than a line, center
\else%
\hbox to\hsize{\normalfont\sffamily\normalsize\hfil\box\@tempboxa\hfil}%
\fi\fi}
\else% nonconference compsoc
\long\def\@makecaption#1#2{%
% test if is a for a figure or table
\ifx\@captype\@CEMtablestring%
% if a table, do table caption
\normalsize\begin{center}{\normalfont\sffamily\normalsize #1}\\{\normalfont\sffamily\normalsize #2}\end{center}%
\@CEMtablecaptionsepspace
% if not a table, format it as a figure
\else
\@CEMfigurecaptionsepspace
\setbox\@tempboxa\hbox{\normalfont\sffamily\normalsize {#1.}~ #2}%
\ifdim \wd\@tempboxa >\hsize%
% if caption is longer than a line, let it wrap around
\setbox\@tempboxa\hbox{\normalfont\sffamily\normalsize {#1.}~ }%
\parbox[t]{\hsize}{\normalfont\sffamily\normalsize \noindent\unhbox\@tempboxa#2}%
% if caption is shorter than a line, left justify
\else%
\hbox to\hsize{\normalfont\sffamily\normalsize\box\@tempboxa\hfil}%
\fi\fi}
\fi

\else% traditional noncompsoc \@makecaption
\long\def\@makecaption#1#2{%
% test if is a for a figure or table
\ifx\@captype\@CEMtablestring%
% if a table, do table caption
%\footnotesize\begin{center}{\normalfont\footnotesize #1}\\{\normalfont\footnotesize\scshape #2}\end{center}%
\footnotesize\begin{center}{\normalfont\footnotesize #1} {\normalfont\footnotesize #2}\end{center}%
\@CEMtablecaptionsepspace
% if not a table, format it as a figure
\else
\@CEMfigurecaptionsepspace
% 3/2001 use footnotesize, not small; use two nonbreaking spaces, not one
\setbox\@tempboxa\hbox{\normalfont\footnotesize {#1.}~~ #2}%
\ifdim \wd\@tempboxa >\hsize%
% if caption is longer than a line, let it wrap around
\setbox\@tempboxa\hbox{\normalfont\footnotesize {#1.}~~ }%
\parbox[t]{\hsize}{\normalfont\footnotesize\noindent\unhbox\@tempboxa#2}%
% if caption is shorter than a line, center if conference, left justify otherwise
\else%
\ifCLASSOPTIONconference \hbox to\hsize{\normalfont\footnotesize\hfil\box\@tempboxa\hfil}%
\else \hbox to\hsize{\normalfont\footnotesize\box\@tempboxa\hfil}%
\fi\fi\fi}
\fi



\ifCLASSOPTIONcaptionsoff
\long\def\@makecaption#1#2{\vspace*{2em}\footnotesize\begin{center}{\footnotesize #1}\end{center}%
\let\@CEMtemporiglabeldefsave\label
\let\@CEMtemplabelargsave\relax
\def\label##1{\gdef\@CEMtemplabelargsave{##1}}%
\setbox\@tempboxa\hbox{#2}%
\let\label\@CEMtemporiglabeldefsave
\ifx\@CEMtemplabelargsave\relax\else\label{\@CEMtemplabelargsave}\fi}
\fi


\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\normalsize{\emph{\figurename~\thefigure}}}
\def\figure{\@float{figure}}
\def\endfigure{\end@float}
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
\newcounter{table}
\ifCLASSOPTIONcompsoc
\def\thetable{\arabic{table}}
\else
%\def\thetable{\@Roman\c@table}
%%% IMPORTANT
\def\thetable{\@arabic\c@table. }
\fi
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\normalsize{\emph{\tablename~\thetable}}}

\def\table{\def\@floatboxreset{\reset@font\normalsize\@setminipage}\@float{table}}
\def\endtable{\end@float}
% v1.6b double column tables need to default to footnotesize as well.
\@namedef{table*}{\def\@floatboxreset{\reset@font\small\@setminipage}\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}




%%
%% START OF CEMeqnarry DEFINITIONS
%%
%% Inspired by the concepts, examples, and previous works of LaTeX 
%% coders and developers such as Donald Arseneau, Fred Bartlett, 
%% David Carlisle, Tony Liu, Frank Mittelbach, Piet van Oostrum, 
%% Roland Winkler and Mark Wooding.
%% I don't make the claim that my work here is even near their calibre. ;)


% hook to allow easy changeover to CEMconf.cls/tools.sty error reporting
\def\@CEMclspkgerror{\ClassError{CEMconf}}

\newif\if@CEMeqnarraystarform% flag to indicate if the environment was called as the star form
\@CEMeqnarraystarformfalse

\newif\if@advanceCEMeqncolcnt% tracks if the environment should advance the col counter
% allows a way to make an \CEMeqnarraybox that can be used within an \CEMeqnarray
% used by CEMeqnarraymulticol so that it can work properly in both
\@advanceCEMeqncolcnttrue

\newcount\@CEMeqnnumcols % tracks how many CEMeqnarray cols are defined
\newcount\@CEMeqncolcnt  % tracks how many CEMeqnarray cols the user actually used


% The default math style used by the columns
\def\CEMeqnarraymathstyle{\displaystyle}
% The default text style used by the columns
% default to using the current font
\def\CEMeqnarraytextstyle{\relax}

% like the iedlistdecl but for \CEMeqnarray
\def\CEMeqnarraydecl{\relax}
\def\CEMeqnarrayboxdecl{\relax}

% \yesnumber is the opposite of \nonumber
% a novel concept with the same def as the equationarray package
% However, we give CEM versions too since some LaTeX packages such as 
% the MDWtools mathenv.sty redefine \nonumber to something else.
\providecommand{\yesnumber}{\global\@eqnswtrue}
\def\CEMyesnumber{\global\@eqnswtrue}
\def\CEMnonumber{\global\@eqnswfalse}


\def\CEMyessubnumber{\global\@CEMissubequationtrue\global\@eqnswtrue%
\if@CEMeqnarrayISinner% only do something inside an CEMeqnarray
\if@CEMlastlinewassubequation\addtocounter{equation}{-1}\else\setcounter{CEMsubequation}{1}\fi%
\def\@currentlabel{\p@CEMsubequation\theCEMsubequation}\fi}

% flag to indicate that an equation is a sub equation
\newif\if@CEMissubequation%
\@CEMissubequationfalse

% allows users to "push away" equations that get too close to the equation numbers
\def\CEMeqnarraynumspace{\hphantom{\if@CEMissubequation\theCEMsubequationdis\else\theequationdis\fi}}

% provides a way to span multiple columns within CEMeqnarray environments
% will consider \if@advanceCEMeqncolcnt before globally advancing the
% column counter - so as to work within \CEMeqnarraybox
% usage: \CEMeqnarraymulticol{number cols. to span}{col type}{cell text}
\long\def\CEMeqnarraymulticol#1#2#3{\multispan{#1}%
% check if column is defined
\relax\expandafter\ifx\csname @CEMeqnarraycolDEF#2\endcsname\@CEMeqnarraycolisdefined%
\csname @CEMeqnarraycolPRE#2\endcsname#3\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\csname @CEMeqnarraycolPOST#2\endcsname%
\else% if not, error and use default type
\@CEMclspkgerror{Invalid column type "#2" in \string\CEMeqnarraymulticol.\MessageBreak
Using a default centering column instead}%
{You must define CEMeqnarray column types before use.}%
\csname @CEMeqnarraycolPRE@CEMdefault\endcsname#3\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\csname @CEMeqnarraycolPOST@CEMdefault\endcsname%
\fi%
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by #1\relax\fi}

% like \omit, but maintains track of the column counter for \CEMeqnarray
\def\CEMeqnarrayomit{\omit\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by 1\relax\fi}


% provides a way to define a letter referenced column type
% usage: \CEMeqnarraydefcol{col. type letter/name}{pre insertion text}{post insertion text}
\def\CEMeqnarraydefcol#1#2#3{\expandafter\def\csname @CEMeqnarraycolPRE#1\endcsname{#2}%
\expandafter\def\csname @CEMeqnarraycolPOST#1\endcsname{#3}%
\expandafter\def\csname @CEMeqnarraycolDEF#1\endcsname{1}}


% provides a way to define a numerically referenced inter-column glue types
% usage: \CEMeqnarraydefcolsep{col. glue number}{glue definition}
\def\CEMeqnarraydefcolsep#1#2{\expandafter\def\csname @CEMeqnarraycolSEP\romannumeral #1\endcsname{#2}%
\expandafter\def\csname @CEMeqnarraycolSEPDEF\romannumeral #1\endcsname{1}}


\def\@CEMeqnarraycolisdefined{1}% just a macro for 1, used for checking undefined column types


% expands and appends the given argument to the \@CEMconftmptoksA token list
% used to build up the \halign preamble
\def\@CEMappendtoksA#1{\edef\@@CEMappendtoksA{\@CEMconftmptoksA={\the\@CEMconftmptoksA #1}}%
\@@CEMappendtoksA}

% also appends to \@CEMconftmptoksA, but does not expand the argument
% uses \toks8 as a scratchpad register
\def\@CEMappendNOEXPANDtoksA#1{\toks8={#1}%
\edef\@@CEMappendNOEXPANDtoksA{\@CEMconftmptoksA={\the\@CEMconftmptoksA\the\toks8}}%
\@@CEMappendNOEXPANDtoksA}

% define some common column types for the user
% math
\CEMeqnarraydefcol{l}{$\CEMeqnarraymathstyle}{$\hfil}
\CEMeqnarraydefcol{c}{\hfil$\CEMeqnarraymathstyle}{$\hfil}
\CEMeqnarraydefcol{r}{\hfil$\CEMeqnarraymathstyle}{$}
\CEMeqnarraydefcol{L}{$\CEMeqnarraymathstyle{}}{{}$\hfil}
\CEMeqnarraydefcol{C}{\hfil$\CEMeqnarraymathstyle{}}{{}$\hfil}
\CEMeqnarraydefcol{R}{\hfil$\CEMeqnarraymathstyle{}}{{}$}
% text
\CEMeqnarraydefcol{s}{\CEMeqnarraytextstyle}{\hfil}
\CEMeqnarraydefcol{t}{\hfil\CEMeqnarraytextstyle}{\hfil}
\CEMeqnarraydefcol{u}{\hfil\CEMeqnarraytextstyle}{}

% vertical rules
\CEMeqnarraydefcol{v}{}{\vrule width\arrayrulewidth}
\CEMeqnarraydefcol{vv}{\vrule width\arrayrulewidth\hfil}{\hfil\vrule width\arrayrulewidth}
\CEMeqnarraydefcol{V}{}{\vrule width\arrayrulewidth\hskip\doublerulesep\vrule width\arrayrulewidth}
\CEMeqnarraydefcol{VV}{\vrule width\arrayrulewidth\hskip\doublerulesep\vrule width\arrayrulewidth\hfil}%
{\hfil\vrule width\arrayrulewidth\hskip\doublerulesep\vrule width\arrayrulewidth}

% horizontal rules
\CEMeqnarraydefcol{h}{}{\leaders\hrule height\arrayrulewidth\hfil}
\CEMeqnarraydefcol{H}{}{\leaders\vbox{\hrule width\arrayrulewidth\vskip\doublerulesep\hrule width\arrayrulewidth}\hfil}

% plain
\CEMeqnarraydefcol{x}{}{}
\CEMeqnarraydefcol{X}{$}{$}

% the default column type to use in the event a column type is not defined
\CEMeqnarraydefcol{@CEMdefault}{\hfil$\CEMeqnarraymathstyle}{$\hfil}


% a zero tabskip (used for "-" col types)
\def\@CEMeqnarraycolSEPzero{0pt plus 0pt minus 0pt}
% a centering tabskip (used for "+" col types)
\def\@CEMeqnarraycolSEPcenter{1000pt plus 0pt minus 1000pt}

% top level default tabskip glues for the start, end, and inter-column
% may be reset within environments not always at the top level, e.g., \CEMeqnarraybox
\edef\@CEMeqnarraycolSEPdefaultstart{\@CEMeqnarraycolSEPcenter}% default start glue
\edef\@CEMeqnarraycolSEPdefaultend{\@CEMeqnarraycolSEPcenter}% default end glue
\edef\@CEMeqnarraycolSEPdefaultmid{\@CEMeqnarraycolSEPzero}% default inter-column glue



% creates a vertical rule that extends from the bottom to the top a a cell
% Provided in case other packages redefine \vline some other way.
% usage: \CEMeqnarrayvrule[rule thickness]
% If no argument is provided, \arrayrulewidth will be used for the rule thickness. 
\newcommand\CEMeqnarrayvrule[1][\arrayrulewidth]{\vrule\@width#1\relax}

% creates a blank separator row
% usage: \CEMeqnarrayseprow[separation length][font size commands]
% default is \CEMeqnarrayseprow[0.25\normalbaselineskip][\relax]
% blank arguments inherit the default values
% uses \skip5 as a scratch register - calls \@CEMeqnarraystrutsize which uses more scratch registers
\def\CEMeqnarrayseprow{\relax\@ifnextchar[{\@CEMeqnarrayseprow}{\@CEMeqnarrayseprow[0.25\normalbaselineskip]}}
\def\@CEMeqnarrayseprow[#1]{\relax\@ifnextchar[{\@@CEMeqnarrayseprow[#1]}{\@@CEMeqnarrayseprow[#1][\relax]}}
\def\@@CEMeqnarrayseprow[#1][#2]{\def\@CEMeqnarrayseprowARGONE{#1}%
\ifx\@CEMeqnarrayseprowARGONE\@empty%
% get the skip value, based on the font commands
% use skip5 because \CEMeqnarraystrutsize uses \skip0, \skip2, \skip3
% assign within a bogus box to confine the font changes
{\setbox0=\hbox{#2\relax\global\skip5=0.25\normalbaselineskip}}%
\else%
{\setbox0=\hbox{#2\relax\global\skip5=#1}}%
\fi%
\@CEMeqnarrayhoptolastcolumn\CEMeqnarraystrutsize{\skip5}{0pt}[\relax]\relax}

% creates a blank separator row, but omits all the column templates
% usage: \CEMeqnarrayseprowcut[separation length][font size commands]
% default is \CEMeqnarrayseprowcut[0.25\normalbaselineskip][\relax]
% blank arguments inherit the default values
% uses \skip5 as a scratch register - calls \@CEMeqnarraystrutsize which uses more scratch registers
\def\CEMeqnarrayseprowcut{\multispan{\@CEMeqnnumcols}\relax% span all the cols
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\@ifnextchar[{\@CEMeqnarrayseprowcut}{\@CEMeqnarrayseprowcut[0.25\normalbaselineskip]}}
\def\@CEMeqnarrayseprowcut[#1]{\relax\@ifnextchar[{\@@CEMeqnarrayseprowcut[#1]}{\@@CEMeqnarrayseprowcut[#1][\relax]}}
\def\@@CEMeqnarrayseprowcut[#1][#2]{\def\@CEMeqnarrayseprowARGONE{#1}%
\ifx\@CEMeqnarrayseprowARGONE\@empty%
% get the skip value, based on the font commands
% use skip5 because \CEMeqnarraystrutsize uses \skip0, \skip2, \skip3
% assign within a bogus box to confine the font changes
{\setbox0=\hbox{#2\relax\global\skip5=0.25\normalbaselineskip}}%
\else%
{\setbox0=\hbox{#2\relax\global\skip5=#1}}%
\fi%
\CEMeqnarraystrutsize{\skip5}{0pt}[\relax]\relax}



% draws a single rule across all the columns optional
% argument determines the rule width, \arrayrulewidth is the default
% updates column counter as needed and turns off struts
% usage: \CEMeqnarrayrulerow[rule line thickness]
\def\CEMeqnarrayrulerow{\multispan{\@CEMeqnnumcols}\relax% span all the cols
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\@ifnextchar[{\@CEMeqnarrayrulerow}{\@CEMeqnarrayrulerow[\arrayrulewidth]}}
\def\@CEMeqnarrayrulerow[#1]{\leaders\hrule height#1\hfil\relax% put in our rule 
% turn off any struts
\CEMeqnarraystrutsize{0pt}{0pt}[\relax]\relax}


% draws a double rule by using a single rule row, a separator row, and then
% another single rule row 
% first optional argument determines the rule thicknesses, \arrayrulewidth is the default
% second optional argument determines the rule spacing, \doublerulesep is the default
% usage: \CEMeqnarraydblrulerow[rule line thickness][rule spacing]
\def\CEMeqnarraydblrulerow{\multispan{\@CEMeqnnumcols}\relax% span all the cols
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\@ifnextchar[{\@CEMeqnarraydblrulerow}{\@CEMeqnarraydblrulerow[\arrayrulewidth]}}
\def\@CEMeqnarraydblrulerow[#1]{\relax\@ifnextchar[{\@@CEMeqnarraydblrulerow[#1]}%
{\@@CEMeqnarraydblrulerow[#1][\doublerulesep]}}
\def\@@CEMeqnarraydblrulerow[#1][#2]{\def\@CEMeqnarraydblrulerowARG{#1}%
% we allow the user to say \CEMeqnarraydblrulerow[][]
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\@CEMeqnarrayrulerow[\arrayrulewidth]%
\else%
\@CEMeqnarrayrulerow[#1]\relax%
\fi%
\def\@CEMeqnarraydblrulerowARG{#2}%
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\\\CEMeqnarrayseprow[\doublerulesep][\relax]%
\else%
\\\CEMeqnarrayseprow[#2][\relax]%
\fi%
\\\multispan{\@CEMeqnnumcols}%
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\def\@CEMeqnarraydblrulerowARG{#1}%
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\@CEMeqnarrayrulerow[\arrayrulewidth]%
\else%
\@CEMeqnarrayrulerow[#1]%
\fi%
}

% draws a double rule by using a single rule row, a separator (cutting) row, and then
% another single rule row 
% first optional argument determines the rule thicknesses, \arrayrulewidth is the default
% second optional argument determines the rule spacing, \doublerulesep is the default
% usage: \CEMeqnarraydblrulerow[rule line thickness][rule spacing]
\def\CEMeqnarraydblrulerowcut{\multispan{\@CEMeqnnumcols}\relax% span all the cols
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\@ifnextchar[{\@CEMeqnarraydblrulerowcut}{\@CEMeqnarraydblrulerowcut[\arrayrulewidth]}}
\def\@CEMeqnarraydblrulerowcut[#1]{\relax\@ifnextchar[{\@@CEMeqnarraydblrulerowcut[#1]}%
{\@@CEMeqnarraydblrulerowcut[#1][\doublerulesep]}}
\def\@@CEMeqnarraydblrulerowcut[#1][#2]{\def\@CEMeqnarraydblrulerowARG{#1}%
% we allow the user to say \CEMeqnarraydblrulerow[][]
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\@CEMeqnarrayrulerow[\arrayrulewidth]%
\else%
\@CEMeqnarrayrulerow[#1]%
\fi%
\def\@CEMeqnarraydblrulerowARG{#2}%
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\\\CEMeqnarrayseprowcut[\doublerulesep][\relax]%
\else%
\\\CEMeqnarrayseprowcut[#2][\relax]%
\fi%
\\\multispan{\@CEMeqnnumcols}%
% advance column counter only if the CEMeqnarray environment wants it
\if@advanceCEMeqncolcnt\global\advance\@CEMeqncolcnt by \@CEMeqnnumcols\relax\fi%
\def\@CEMeqnarraydblrulerowARG{#1}%
\ifx\@CEMeqnarraydblrulerowARG\@empty%
\@CEMeqnarrayrulerow[\arrayrulewidth]%
\else%
\@CEMeqnarrayrulerow[#1]%
\fi%
}



% inserts a full row's worth of &'s
% relies on \@CEMeqnnumcols to provide the correct number of columns
% uses \@CEMconftmptoksA, \count0 as scratch registers
\def\@CEMeqnarrayhoptolastcolumn{\@CEMconftmptoksA={}\count0=1\relax%
\loop% add cols if the user did not use them all
\ifnum\count0<\@CEMeqnnumcols\relax%
\@CEMappendtoksA{&}%
\advance\count0 by 1\relax% update the col count
\repeat%
\the\@CEMconftmptoksA%execute the &'s
}



\newif\if@CEMeqnarrayISinner % flag to indicate if we are within the lines
\@CEMeqnarrayISinnerfalse    % of an CEMeqnarray - after the CEMeqnarraydecl

\edef\@CEMeqnarrayTHEstrutheight{0pt} % height and depth of CEMeqnarray struts
\edef\@CEMeqnarrayTHEstrutdepth{0pt}

\edef\@CEMeqnarrayTHEmasterstrutheight{0pt} % default height and depth of
\edef\@CEMeqnarrayTHEmasterstrutdepth{0pt}  % struts within an CEMeqnarray

\edef\@CEMeqnarrayTHEmasterstrutHSAVE{0pt} % saved master strut height
\edef\@CEMeqnarrayTHEmasterstrutDSAVE{0pt} % and depth

\newif\if@CEMeqnarrayusemasterstrut % flag to indicate that the master strut value
\@CEMeqnarrayusemasterstruttrue     % is to be used



% saves the strut height and depth of the master strut
\def\@CEMeqnarraymasterstrutsave{\relax%
\expandafter\skip0=\@CEMeqnarrayTHEmasterstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEmasterstrutdepth\relax%
% remove stretchability
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% save values
\edef\@CEMeqnarrayTHEmasterstrutHSAVE{\the\dimen0}%
\edef\@CEMeqnarrayTHEmasterstrutDSAVE{\the\dimen2}}

% restores the strut height and depth of the master strut
\def\@CEMeqnarraymasterstrutrestore{\relax%
\expandafter\skip0=\@CEMeqnarrayTHEmasterstrutHSAVE\relax%
\expandafter\skip2=\@CEMeqnarrayTHEmasterstrutDSAVE\relax%
% remove stretchability
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% restore values
\edef\@CEMeqnarrayTHEmasterstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEmasterstrutdepth{\the\dimen2}}


% globally restores the strut height and depth to the 
% master values and sets the master strut flag to true
\def\@CEMeqnarraystrutreset{\relax%
\expandafter\skip0=\@CEMeqnarrayTHEmasterstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEmasterstrutdepth\relax%
% remove stretchability
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% restore values
\xdef\@CEMeqnarrayTHEstrutheight{\the\dimen0}%
\xdef\@CEMeqnarrayTHEstrutdepth{\the\dimen2}%
\global\@CEMeqnarrayusemasterstruttrue}


% if the master strut is not to be used, make the current
% values of \@CEMeqnarrayTHEstrutheight, \@CEMeqnarrayTHEstrutdepth
% and the use master strut flag, global
% this allows user strut commands issued in the last column to be carried
% into the isolation/strut column
\def\@CEMeqnarrayglobalizestrutstatus{\relax%
\if@CEMeqnarrayusemasterstrut\else%
\xdef\@CEMeqnarrayTHEstrutheight{\@CEMeqnarrayTHEstrutheight}%
\xdef\@CEMeqnarrayTHEstrutdepth{\@CEMeqnarrayTHEstrutdepth}%
\global\@CEMeqnarrayusemasterstrutfalse%
\fi}



% usage: \CEMeqnarraystrutsize{height}{depth}[font size commands]
% If called outside the lines of an CEMeqnarray, sets the height
% and depth of both the master and local struts. If called inside
% an CEMeqnarray line, sets the height and depth of the local strut
% only and sets the flag to indicate the use of the local strut
% values. If the height or depth is left blank, 0.7\normalbaselineskip
% and 0.3\normalbaselineskip will be used, respectively.
% The optional argument can be used to evaluate the lengths under
% a different font size and styles. If none is specified, the current
% font is used.
% uses scratch registers \skip0, \skip2, \skip3, \dimen0, \dimen2
\def\CEMeqnarraystrutsize#1#2{\relax\@ifnextchar[{\@CEMeqnarraystrutsize{#1}{#2}}{\@CEMeqnarraystrutsize{#1}{#2}[\relax]}}
\def\@CEMeqnarraystrutsize#1#2[#3]{\def\@CEMeqnarraystrutsizeARG{#1}%
\ifx\@CEMeqnarraystrutsizeARG\@empty%
{\setbox0=\hbox{#3\relax\global\skip3=0.7\normalbaselineskip}}%
\skip0=\skip3\relax%
\else% arg one present
{\setbox0=\hbox{#3\relax\global\skip3=#1\relax}}%
\skip0=\skip3\relax%
\fi% if null arg
\def\@CEMeqnarraystrutsizeARG{#2}%
\ifx\@CEMeqnarraystrutsizeARG\@empty%
{\setbox0=\hbox{#3\relax\global\skip3=0.3\normalbaselineskip}}%
\skip2=\skip3\relax%
\else% arg two present
{\setbox0=\hbox{#3\relax\global\skip3=#2\relax}}%
\skip2=\skip3\relax%
\fi% if null arg
% remove stretchability, just to be safe
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% dimen0 = height, dimen2 = depth
\if@CEMeqnarrayISinner% inner does not touch master strut size
\edef\@CEMeqnarrayTHEstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEstrutdepth{\the\dimen2}%
\@CEMeqnarrayusemasterstrutfalse% do not use master
\else% outer, have to set master strut too
\edef\@CEMeqnarrayTHEmasterstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEmasterstrutdepth{\the\dimen2}%
\edef\@CEMeqnarrayTHEstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEstrutdepth{\the\dimen2}%
\@CEMeqnarrayusemasterstruttrue% use master strut
\fi}


% usage: \CEMeqnarraystrutsizeadd{added height}{added depth}[font size commands]
% If called outside the lines of an CEMeqnarray, adds the given height
% and depth to both the master and local struts.
% If called inside an CEMeqnarray line, adds the given height and depth
% to the local strut only and sets the flag to indicate the use 
% of the local strut values.
% In both cases, if a height or depth is left blank, 0pt is used instead.
% The optional argument can be used to evaluate the lengths under
% a different font size and styles. If none is specified, the current
% font is used.
% uses scratch registers \skip0, \skip2, \skip3, \dimen0, \dimen2
\def\CEMeqnarraystrutsizeadd#1#2{\relax\@ifnextchar[{\@CEMeqnarraystrutsizeadd{#1}{#2}}{\@CEMeqnarraystrutsizeadd{#1}{#2}[\relax]}}
\def\@CEMeqnarraystrutsizeadd#1#2[#3]{\def\@CEMeqnarraystrutsizearg{#1}%
\ifx\@CEMeqnarraystrutsizearg\@empty%
\skip0=0pt\relax%
\else% arg one present
{\setbox0=\hbox{#3\relax\global\skip3=#1}}%
\skip0=\skip3\relax%
\fi% if null arg
\def\@CEMeqnarraystrutsizearg{#2}%
\ifx\@CEMeqnarraystrutsizearg\@empty%
\skip2=0pt\relax%
\else% arg two present
{\setbox0=\hbox{#3\relax\global\skip3=#2}}%
\skip2=\skip3\relax%
\fi% if null arg
% remove stretchability, just to be safe
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% dimen0 = height, dimen2 = depth
\if@CEMeqnarrayISinner% inner does not touch master strut size
% get local strut size
\expandafter\skip0=\@CEMeqnarrayTHEstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEstrutdepth\relax%
% add it to the user supplied values
\advance\dimen0 by \skip0\relax%
\advance\dimen2 by \skip2\relax%
% update the local strut size
\edef\@CEMeqnarrayTHEstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEstrutdepth{\the\dimen2}%
\@CEMeqnarrayusemasterstrutfalse% do not use master
\else% outer, have to set master strut too
% get master strut size
\expandafter\skip0=\@CEMeqnarrayTHEmasterstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEmasterstrutdepth\relax%
% add it to the user supplied values
\advance\dimen0 by \skip0\relax%
\advance\dimen2 by \skip2\relax%
% update the local and master strut sizes
\edef\@CEMeqnarrayTHEmasterstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEmasterstrutdepth{\the\dimen2}%
\edef\@CEMeqnarrayTHEstrutheight{\the\dimen0}%
\edef\@CEMeqnarrayTHEstrutdepth{\the\dimen2}%
\@CEMeqnarrayusemasterstruttrue% use master strut
\fi}


% allow user a way to see the struts
\newif\ifCEMvisiblestruts
\CEMvisiblestrutsfalse

% inserts an invisible strut using the master or local strut values
% uses scratch registers \skip0, \skip2, \dimen0, \dimen2
\def\@CEMeqnarrayinsertstrut{\relax%
\if@CEMeqnarrayusemasterstrut
% get master strut size
\expandafter\skip0=\@CEMeqnarrayTHEmasterstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEmasterstrutdepth\relax%
\else%
% get local strut size
\expandafter\skip0=\@CEMeqnarrayTHEstrutheight\relax%
\expandafter\skip2=\@CEMeqnarrayTHEstrutdepth\relax%
\fi%
% remove stretchability, probably not needed
\dimen0\skip0\relax%
\dimen2\skip2\relax%
% dimen0 = height, dimen2 = depth
% allow user to see struts if desired
\ifCEMvisiblestruts%
\vrule width0.2pt height\dimen0 depth\dimen2\relax%
\else%
\vrule width0pt height\dimen0 depth\dimen2\relax\fi}


% creates an invisible strut, useable even outside \CEMeqnarray
% if \CEMvisiblestrutstrue, the strut will be visible and 0.2pt wide. 
% usage: \CEMstrut[height][depth][font size commands]
% default is \CEMstrut[0.7\normalbaselineskip][0.3\normalbaselineskip][\relax]
% blank arguments inherit the default values
% uses \dimen0, \dimen2, \skip0, \skip2
\def\CEMstrut{\relax\@ifnextchar[{\@CEMstrut}{\@CEMstrut[0.7\normalbaselineskip]}}
\def\@CEMstrut[#1]{\relax\@ifnextchar[{\@@CEMstrut[#1]}{\@@CEMstrut[#1][0.3\normalbaselineskip]}}
\def\@@CEMstrut[#1][#2]{\relax\@ifnextchar[{\@@@CEMstrut[#1][#2]}{\@@@CEMstrut[#1][#2][\relax]}}
\def\@@@CEMstrut[#1][#2][#3]{\mbox{#3\relax%
\def\@CEMstrutARG{#1}%
\ifx\@CEMstrutARG\@empty%
\skip0=0.7\normalbaselineskip\relax%
\else%
\skip0=#1\relax%
\fi%
\def\@CEMstrutARG{#2}%
\ifx\@CEMstrutARG\@empty%
\skip2=0.3\normalbaselineskip\relax%
\else%
\skip2=#2\relax%
\fi%
% remove stretchability, probably not needed
\dimen0\skip0\relax%
\dimen2\skip2\relax%
\ifCEMvisiblestruts%
\vrule width0.2pt height\dimen0 depth\dimen2\relax%
\else%
\vrule width0.0pt height\dimen0 depth\dimen2\relax\fi}}


% enables strut mode by setting a default strut size and then zeroing the
% \baselineskip, \lineskip, \lineskiplimit and \jot
\def\CEMeqnarraystrutmode{\CEMeqnarraystrutsize{0.7\normalbaselineskip}{0.3\normalbaselineskip}[\relax]%
\baselineskip=0pt\lineskip=0pt\lineskiplimit=0pt\jot=0pt}



\def\CEMeqnarray{\@CEMeqnarraystarformfalse\@CEMeqnarray}
\def\endCEMeqnarray{\end@CEMeqnarray}

\@namedef{CEMeqnarray*}{\@CEMeqnarraystarformtrue\@CEMeqnarray}
\@namedef{endCEMeqnarray*}{\end@CEMeqnarray}


% \CEMeqnarray is an enhanced \eqnarray. 
% The star form defaults to not putting equation numbers at the end of each row.
% usage: \CEMeqnarray[decl]{cols}
\def\@CEMeqnarray{\relax\@ifnextchar[{\@@CEMeqnarray}{\@@CEMeqnarray[\relax]}}
\def\@@CEMeqnarray[#1]#2{%
   % default to showing the equation number or not based on whether or not
   % the star form was involked
   \if@CEMeqnarraystarform\global\@eqnswfalse
   \else% not the star form
   \global\@eqnswtrue
   \fi% if star form
   \@CEMissubequationfalse% default to no subequations
   \@CEMlastlinewassubequationfalse% assume last line is not a sub equation
   \@CEMeqnarrayISinnerfalse% not yet within the lines of the halign
   \@CEMeqnarraystrutsize{0pt}{0pt}[\relax]% turn off struts by default
   \@CEMeqnarrayusemasterstruttrue% use master strut till user asks otherwise
   \CEMvisiblestrutsfalse% diagnostic mode defaults to off
   % no extra space unless the user specifically requests it
   \lineskip=0pt\relax
   \lineskiplimit=0pt\relax
   \baselineskip=\normalbaselineskip\relax%
   \jot=\CEMnormaljot\relax%
   \mathsurround\z@\relax% no extra spacing around math
   \@advanceCEMeqncolcnttrue% advance the col counter for each col the user uses, 
                             % used in \CEMeqnarraymulticol and in the preamble build
   \stepcounter{equation}% advance equation counter before first line
   \setcounter{CEMsubequation}{0}% no subequation yet 
   \def\@currentlabel{\p@equation\theequation}% redefine the ref label
   \CEMeqnarraydecl\relax% allow a way for the user to make global overrides
   #1\relax% allow user to override defaults
   \let\\\@CEMeqnarraycr% replace newline with one that can put in eqn. numbers
   \global\@CEMeqncolcnt\z@% col. count = 0 for first line
   \@CEMbuildpreamble #2\end\relax% build the preamble and put it into \@CEMconftmptoksA 
   % put in the column for the equation number
   \ifnum\@CEMeqnnumcols>0\relax\@CEMappendtoksA{&}\fi% col separator for those after the first
   \toks0={##}%
   % advance the \@CEMeqncolcnt for the isolation col, this helps with error checking
   \@CEMappendtoksA{\global\advance\@CEMeqncolcnt by 1\relax}%
   % add the isolation column
   \@CEMappendtoksA{\tabskip\z@skip\bgroup\the\toks0\egroup}%
   % advance the \@CEMeqncolcnt for the equation number col, this helps with error checking
   \@CEMappendtoksA{&\global\advance\@CEMeqncolcnt by 1\relax}%
   % add the equation number col to the preamble
   \@CEMappendtoksA{\tabskip\z@skip\hb@xt@\z@\bgroup\hss\the\toks0\egroup}%
   % note \@CEMeqnnumcols does not count the equation col or isolation col
   % set the starting tabskip glue as determined by the preamble build
   \tabskip=\@CEMBPstartglue\relax
   % begin the display alignment
   \@CEMeqnarrayISinnertrue% commands are now within the lines
   $$\everycr{}\halign to\displaywidth\bgroup
   % "exspand" the preamble
   \span\the\@CEMconftmptoksA\cr}

% enter isolation/strut column (or the next column if the user did not use
% every column), record the strut status, complete the columns, do the strut if needed,
% restore counters to correct values and exit
\def\end@CEMeqnarray{\@CEMeqnarrayglobalizestrutstatus&\@@CEMeqnarraycr\egroup%
\if@CEMlastlinewassubequation\global\advance\c@CEMsubequation\m@ne\fi%
\global\advance\c@equation\m@ne%
$$\@ignoretrue}

% need a way to remember if last line is a subequation
\newif\if@CEMlastlinewassubequation%
\@CEMlastlinewassubequationfalse

% CEMeqnarray uses a modifed \\ instead of the plain \cr to
% end rows. This allows for things like \\*[vskip amount]
% This "cr" macros are modified versions those for LaTeX2e's eqnarray
% the {\ifnum0=`} braces must be kept away from the last column to avoid
% altering spacing of its math, so we use & to advance to the next column
% as there is an isolation/strut column after the user's columns
\def\@CEMeqnarraycr{\@CEMeqnarrayglobalizestrutstatus&% save strut status and advance to next column
   {\ifnum0=`}\fi
   \@ifstar{%
      \global\@eqpen\@M\@CEMeqnarrayYCR
   }{%
      \global\@eqpen\interdisplaylinepenalty \@CEMeqnarrayYCR
   }%
}

\def\@CEMeqnarrayYCR{\@testopt\@CEMeqnarrayXCR\z@skip}

\def\@CEMeqnarrayXCR[#1]{%
   \ifnum0=`{\fi}%
   \@@CEMeqnarraycr
   \noalign{\penalty\@eqpen\vskip\jot\vskip #1\relax}}%

\def\@@CEMeqnarraycr{\@CEMconftmptoksA={}% clear token register
    \advance\@CEMeqncolcnt by -1\relax% adjust col count because of the isolation column
    \ifnum\@CEMeqncolcnt>\@CEMeqnnumcols\relax
    \@CEMclspkgerror{Too many columns within the CEMeqnarray\MessageBreak
                          environment}%
    {Use fewer \string &'s or put more columns in the CEMeqnarry column\MessageBreak 
     specifications.}\relax%
    \else
    \loop% add cols if the user did not use them all
    \ifnum\@CEMeqncolcnt<\@CEMeqnnumcols\relax
    \@CEMappendtoksA{&}%
    \advance\@CEMeqncolcnt by 1\relax% update the col count
    \repeat
    % this number of &'s will take us the the isolation column
    \fi
    % execute the &'s
    \the\@CEMconftmptoksA%
    % handle the strut/isolation column
    \@CEMeqnarrayinsertstrut% do the strut if needed
    \@CEMeqnarraystrutreset% reset the strut system for next line or CEMeqnarray
    &% and enter the equation number column
    % is this line needs an equation number, display it and advance the
    % (sub)equation counters, record what type this line was
    \if@eqnsw%
     \if@CEMissubequation\theCEMsubequationdis\addtocounter{equation}{1}\stepcounter{CEMsubequation}%
     \global\@CEMlastlinewassubequationtrue%
     \else% display a standard equation number, initialize the CEMsubequation counter
     \theequationdis\stepcounter{equation}\setcounter{CEMsubequation}{0}%
     \global\@CEMlastlinewassubequationfalse\fi%
    \fi%
    % reset the eqnsw flag to indicate default preference of the display of equation numbers
    \if@CEMeqnarraystarform\global\@eqnswfalse\else\global\@eqnswtrue\fi
    \global\@CEMissubequationfalse% reset the subequation flag
    % reset the number of columns the user actually used
    \global\@CEMeqncolcnt\z@\relax
    % the real end of the line
    \cr}





% \CEMeqnarraybox is like \CEMeqnarray except the box form puts everything
% inside a vtop, vbox, or vcenter box depending on the letter in the second
% optional argument (t,b,c). Vbox is the default. Unlike \CEMeqnarray,
% equation numbers are not displayed and \CEMeqnarraybox can be nested.
% \CEMeqnarrayboxm is for math mode (like \array) and does not put the vbox
% within an hbox.
% \CEMeqnarrayboxt is for text mode (like \tabular) and puts the vbox within
% a \hbox{$ $} construct.
% \CEMeqnarraybox will auto detect whether to use \CEMeqnarrayboxm or 
% \CEMeqnarrayboxt depending on the math mode.
% The third optional argument specifies the width this box is to be set to -
% natural width is the default.
% The * forms do not add \jot line spacing
% usage: \CEMeqnarraybox[decl][pos][width]{cols}
\def\CEMeqnarrayboxm{\@CEMeqnarraystarformfalse\@CEMeqnarrayboxHBOXSWfalse\@CEMeqnarraybox}
\def\endCEMeqnarrayboxm{\end@CEMeqnarraybox}
\@namedef{CEMeqnarrayboxm*}{\@CEMeqnarraystarformtrue\@CEMeqnarrayboxHBOXSWfalse\@CEMeqnarraybox}
\@namedef{endCEMeqnarrayboxm*}{\end@CEMeqnarraybox}

\def\CEMeqnarrayboxt{\@CEMeqnarraystarformfalse\@CEMeqnarrayboxHBOXSWtrue\@CEMeqnarraybox}
\def\endCEMeqnarrayboxt{\end@CEMeqnarraybox}
\@namedef{CEMeqnarrayboxt*}{\@CEMeqnarraystarformtrue\@CEMeqnarrayboxHBOXSWtrue\@CEMeqnarraybox}
\@namedef{endCEMeqnarrayboxt*}{\end@CEMeqnarraybox}

\def\CEMeqnarraybox{\@CEMeqnarraystarformfalse\ifmmode\@CEMeqnarrayboxHBOXSWfalse\else\@CEMeqnarrayboxHBOXSWtrue\fi%
\@CEMeqnarraybox}
\def\endCEMeqnarraybox{\end@CEMeqnarraybox}

\@namedef{CEMeqnarraybox*}{\@CEMeqnarraystarformtrue\ifmmode\@CEMeqnarrayboxHBOXSWfalse\else\@CEMeqnarrayboxHBOXSWtrue\fi%
\@CEMeqnarraybox}
\@namedef{endCEMeqnarraybox*}{\end@CEMeqnarraybox}

% flag to indicate if the \CEMeqnarraybox needs to put things into an hbox{$ $} 
% for \vcenter in non-math mode
\newif\if@CEMeqnarrayboxHBOXSW%
\@CEMeqnarrayboxHBOXSWfalse

\def\@CEMeqnarraybox{\relax\@ifnextchar[{\@@CEMeqnarraybox}{\@@CEMeqnarraybox[\relax]}}
\def\@@CEMeqnarraybox[#1]{\relax\@ifnextchar[{\@@@CEMeqnarraybox[#1]}{\@@@CEMeqnarraybox[#1][b]}}
\def\@@@CEMeqnarraybox[#1][#2]{\relax\@ifnextchar[{\@@@@CEMeqnarraybox[#1][#2]}{\@@@@CEMeqnarraybox[#1][#2][\relax]}}

% #1 = decl; #2 = t,b,c; #3 = width, #4 = col specs
\def\@@@@CEMeqnarraybox[#1][#2][#3]#4{\@CEMeqnarrayISinnerfalse % not yet within the lines of the halign
   \@CEMeqnarraymasterstrutsave% save current master strut values
   \@CEMeqnarraystrutsize{0pt}{0pt}[\relax]% turn off struts by default
   \@CEMeqnarrayusemasterstruttrue% use master strut till user asks otherwise
   \CEMvisiblestrutsfalse% diagnostic mode defaults to off
   % no extra space unless the user specifically requests it
   \lineskip=0pt\relax%
   \lineskiplimit=0pt\relax%
   \baselineskip=\normalbaselineskip\relax%
   \jot=\CEMnormaljot\relax%
   \mathsurround\z@\relax% no extra spacing around math
   % the default end glues are zero for an \CEMeqnarraybox
   \edef\@CEMeqnarraycolSEPdefaultstart{\@CEMeqnarraycolSEPzero}% default start glue
   \edef\@CEMeqnarraycolSEPdefaultend{\@CEMeqnarraycolSEPzero}% default end glue
   \edef\@CEMeqnarraycolSEPdefaultmid{\@CEMeqnarraycolSEPzero}% default inter-column glue
   \@advanceCEMeqncolcntfalse% do not advance the col counter for each col the user uses, 
                              % used in \CEMeqnarraymulticol and in the preamble build
   \CEMeqnarrayboxdecl\relax% allow a way for the user to make global overrides
   #1\relax% allow user to override defaults
   \let\\\@CEMeqnarrayboxcr% replace newline with one that allows optional spacing
   \@CEMbuildpreamble #4\end\relax% build the preamble and put it into \@CEMconftmptoksA
   % add an isolation column to the preamble to stop \\'s {} from getting into the last col
   \ifnum\@CEMeqnnumcols>0\relax\@CEMappendtoksA{&}\fi% col separator for those after the first
   \toks0={##}%
   % add the isolation column to the preamble
   \@CEMappendtoksA{\tabskip\z@skip\bgroup\the\toks0\egroup}% 
   % set the starting tabskip glue as determined by the preamble build
   \tabskip=\@CEMBPstartglue\relax
   % begin the alignment
   \everycr{}%
   % use only the very first token to determine the positioning
   % this stops some problems when the user uses more than one letter,
   % but is probably not worth the effort
   % \noindent is used as a delimiter
   \def\@CEMgrabfirstoken##1##2\noindent{\let\@CEMgrabbedfirstoken=##1}%
   \@CEMgrabfirstoken#2\relax\relax\noindent
   % \@CEMgrabbedfirstoken has the first token, the rest are discarded
   % if we need to put things into and hbox and go into math mode, do so now
   \if@CEMeqnarrayboxHBOXSW \leavevmode \hbox \bgroup $\fi%
   % use the appropriate vbox type
   \if\@CEMgrabbedfirstoken t\relax\vtop\else\if\@CEMgrabbedfirstoken c\relax%
   \vcenter\else\vbox\fi\fi\bgroup%
   \@CEMeqnarrayISinnertrue% commands are now within the lines
   \ifx#3\relax\halign\else\halign to #3\relax\fi%
   \bgroup
   % "exspand" the preamble
   \span\the\@CEMconftmptoksA\cr}

% carry strut status and enter the isolation/strut column, 
% exit from math mode if needed, and exit
\def\end@CEMeqnarraybox{\@CEMeqnarrayglobalizestrutstatus% carry strut status
&% enter isolation/strut column
\@CEMeqnarrayinsertstrut% do strut if needed
\@CEMeqnarraymasterstrutrestore% restore the previous master strut values
% reset the strut system for next CEMeqnarray
% (sets local strut values back to previous master strut values)
\@CEMeqnarraystrutreset%
% ensure last line, exit from halign, close vbox
\crcr\egroup\egroup%
% exit from math mode and close hbox if needed
\if@CEMeqnarrayboxHBOXSW $\egroup\fi}



% CEMeqnarraybox uses a modifed \\ instead of the plain \cr to
% end rows. This allows for things like \\[vskip amount]
% This "cr" macros are modified versions those for LaTeX2e's eqnarray
% For CEMeqnarraybox, \\* is the same as \\
% the {\ifnum0=`} braces must be kept away from the last column to avoid
% altering spacing of its math, so we use & to advance to the isolation/strut column
% carry strut status into isolation/strut column
\def\@CEMeqnarrayboxcr{\@CEMeqnarrayglobalizestrutstatus% carry strut status
&% enter isolation/strut column
\@CEMeqnarrayinsertstrut% do strut if needed
% reset the strut system for next line or CEMeqnarray
\@CEMeqnarraystrutreset%
{\ifnum0=`}\fi%
\@ifstar{\@CEMeqnarrayboxYCR}{\@CEMeqnarrayboxYCR}}

% test and setup the optional argument to \\[]
\def\@CEMeqnarrayboxYCR{\@testopt\@CEMeqnarrayboxXCR\z@skip}

% CEMeqnarraybox does not automatically increase line spacing by \jot
\def\@CEMeqnarrayboxXCR[#1]{\ifnum0=`{\fi}%
\cr\noalign{\if@CEMeqnarraystarform\else\vskip\jot\fi\vskip#1\relax}}



% starts the halign preamble build
\def\@CEMbuildpreamble{\@CEMconftmptoksA={}% clear token register
\let\@CEMBPcurtype=u%current column type is not yet known
\let\@CEMBPprevtype=s%the previous column type was the start
\let\@CEMBPnexttype=u%next column type is not yet known
% ensure these are valid
\def\@CEMBPcurglue={0pt plus 0pt minus 0pt}%
\def\@CEMBPcurcolname{@CEMdefault}% name of current column definition
% currently acquired numerically referenced glue
% use a name that is easier to remember
\let\@CEMBPcurnum=\@CEMconftmpcountA%
\@CEMBPcurnum=0%
% tracks number of columns in the preamble
\@CEMeqnnumcols=0%
% record the default end glues
\edef\@CEMBPstartglue{\@CEMeqnarraycolSEPdefaultstart}%
\edef\@CEMBPendglue{\@CEMeqnarraycolSEPdefaultend}%
% now parse the user's column specifications
\@@CEMbuildpreamble}


% parses and builds the halign preamble
\def\@@CEMbuildpreamble#1#2{\let\@@nextCEMbuildpreamble=\@@CEMbuildpreamble%
% use only the very first token to check the end
% \noindent is used as a delimiter as \end can be present here
\def\@CEMgrabfirstoken##1##2\noindent{\let\@CEMgrabbedfirstoken=##1}%
\@CEMgrabfirstoken#1\relax\relax\noindent
\ifx\@CEMgrabbedfirstoken\end\let\@@nextCEMbuildpreamble=\@@CEMfinishpreamble\else%
% identify current and next token type
\@CEMgetcoltype{#1}{\@CEMBPcurtype}{1}% current, error on invalid
\@CEMgetcoltype{#2}{\@CEMBPnexttype}{0}% next, no error on invalid next
% if curtype is a glue, get the glue def
\if\@CEMBPcurtype g\@CEMgetcurglue{#1}{\@CEMBPcurglue}\fi%
% if curtype is a column, get the column def and set the current column name
\if\@CEMBPcurtype c\@CEMgetcurcol{#1}\fi%
% if curtype is a numeral, acquire the user defined glue
\if\@CEMBPcurtype n\@CEMprocessNcol{#1}\fi%
% process the acquired glue 
\if\@CEMBPcurtype g\@CEMprocessGcol\fi%
% process the acquired col 
\if\@CEMBPcurtype c\@CEMprocessCcol\fi%
% ready prevtype for next col spec.
\let\@CEMBPprevtype=\@CEMBPcurtype%
% be sure and put back the future token(s) as a group
\fi\@@nextCEMbuildpreamble{#2}}


% executed just after preamble build is completed
% warn about zero cols, and if prevtype type = u, put in end tabskip glue
\def\@@CEMfinishpreamble#1{\ifnum\@CEMeqnnumcols<1\relax
\@CEMclspkgerror{No column specifiers declared for CEMeqnarray}%
{At least one column type must be declared for each CEMeqnarray.}%
\fi%num cols less than 1
%if last type undefined, set default end tabskip glue
\if\@CEMBPprevtype u\@CEMappendtoksA{\tabskip=\@CEMBPendglue}\fi}


% Identify and return the column specifier's type code
\def\@CEMgetcoltype#1#2#3{%
% use only the very first token to determine the type
% \noindent is used as a delimiter as \end can be present here
\def\@CEMgrabfirstoken##1##2\noindent{\let\@CEMgrabbedfirstoken=##1}%
\@CEMgrabfirstoken#1\relax\relax\noindent
% \@CEMgrabfirstoken has the first token, the rest are discarded
% n = number
% g = glue (any other char in catagory 12)
% c = letter
% e = \end
% u = undefined
% third argument: 0 = no error message, 1 = error on invalid char
\let#2=u\relax% assume invalid until know otherwise
\ifx\@CEMgrabbedfirstoken\end\let#2=e\else
\ifcat\@CEMgrabbedfirstoken\relax\else% screen out control sequences
\if0\@CEMgrabbedfirstoken\let#2=n\else
\if1\@CEMgrabbedfirstoken\let#2=n\else
\if2\@CEMgrabbedfirstoken\let#2=n\else
\if3\@CEMgrabbedfirstoken\let#2=n\else
\if4\@CEMgrabbedfirstoken\let#2=n\else
\if5\@CEMgrabbedfirstoken\let#2=n\else
\if6\@CEMgrabbedfirstoken\let#2=n\else
\if7\@CEMgrabbedfirstoken\let#2=n\else
\if8\@CEMgrabbedfirstoken\let#2=n\else
\if9\@CEMgrabbedfirstoken\let#2=n\else
\ifcat,\@CEMgrabbedfirstoken\let#2=g\relax
\else\ifcat a\@CEMgrabbedfirstoken\let#2=c\relax\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi
\if#2u\relax
\if0\noexpand#3\relax\else\@CEMclspkgerror{Invalid character in column specifications}%
{Only letters, numerals and certain other symbols are allowed \MessageBreak
as CEMeqnarray column specifiers.}\fi\fi}


% identify the current letter referenced column
% if invalid, use a default column
\def\@CEMgetcurcol#1{\expandafter\ifx\csname @CEMeqnarraycolDEF#1\endcsname\@CEMeqnarraycolisdefined%
\def\@CEMBPcurcolname{#1}\else% invalid column name
\@CEMclspkgerror{Invalid column type "#1" in column specifications.\MessageBreak
Using a default centering column instead}%
{You must define CEMeqnarray column types before use.}%
\def\@CEMBPcurcolname{@CEMdefault}\fi}


% identify and return the predefined (punctuation) glue value
\def\@CEMgetcurglue#1#2{%
% ! = \! (neg small)  -0.16667em (-3/18 em)
% , = \, (small)       0.16667em ( 3/18 em)
% : = \: (med)         0.22222em ( 4/18 em)
% ; = \; (large)       0.27778em ( 5/18 em)
% ' = \quad            1em
% " = \qquad           2em
% . = 0.5\arraycolsep
% / = \arraycolsep
% ? = 2\arraycolsep
% * = 1fil
% + = \@CEMeqnarraycolSEPcenter
% - = \@CEMeqnarraycolSEPzero
% Note that all em values are referenced to the math font (textfont2) fontdimen6
% value for 1em.
% 
% use only the very first token to determine the type
% this prevents errant tokens from getting in the main text
% \noindent is used as a delimiter here
\def\@CEMgrabfirstoken##1##2\noindent{\let\@CEMgrabbedfirstoken=##1}%
\@CEMgrabfirstoken#1\relax\relax\noindent
% get the math font 1em value
% LaTeX2e's NFSS2 does not preload the fonts, but \CEMeqnarray needs
% to gain access to the math (\textfont2) font's spacing parameters.
% So we create a bogus box here that uses the math font to ensure
% that \textfont2 is loaded and ready. If this is not done,
% the \textfont2 stuff here may not work.
% Thanks to Bernd Raichle for his 1997 post on this topic.
{\setbox0=\hbox{$\displaystyle\relax$}}%
% fontdimen6 has the width of 1em (a quad).
\@CEMconftmpdimenA=\fontdimen6\textfont2\relax%
% identify the glue value based on the first token
% we discard anything after the first
\if!\@CEMgrabbedfirstoken\@CEMconftmpdimenA=-0.16667\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if,\@CEMgrabbedfirstoken\@CEMconftmpdimenA=0.16667\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if:\@CEMgrabbedfirstoken\@CEMconftmpdimenA=0.22222\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if;\@CEMgrabbedfirstoken\@CEMconftmpdimenA=0.27778\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if'\@CEMgrabbedfirstoken\@CEMconftmpdimenA=1\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if"\@CEMgrabbedfirstoken\@CEMconftmpdimenA=2\@CEMconftmpdimenA\edef#2{\the\@CEMconftmpdimenA}\else
\if.\@CEMgrabbedfirstoken\@CEMconftmpdimenA=0.5\arraycolsep\edef#2{\the\@CEMconftmpdimenA}\else
\if/\@CEMgrabbedfirstoken\edef#2{\the\arraycolsep}\else
\if?\@CEMgrabbedfirstoken\@CEMconftmpdimenA=2\arraycolsep\edef#2{\the\@CEMconftmpdimenA}\else
\if *\@CEMgrabbedfirstoken\edef#2{0pt plus 1fil minus 0pt}\else
\if+\@CEMgrabbedfirstoken\edef#2{\@CEMeqnarraycolSEPcenter}\else
\if-\@CEMgrabbedfirstoken\edef#2{\@CEMeqnarraycolSEPzero}\else
\edef#2{\@CEMeqnarraycolSEPzero}%
\@CEMclspkgerror{Invalid predefined inter-column glue type "#1" in\MessageBreak
column specifications. Using a default value of\MessageBreak
0pt instead}%
{Only !,:;'"./?*+ and - are valid predefined glue types in the\MessageBreak 
CEMeqnarray column specifications.}\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi\fi}



% process a numerical digit from the column specification
% and look up the corresponding user defined glue value
% can transform current type from n to g or a as the user defined glue is acquired
\def\@CEMprocessNcol#1{\if\@CEMBPprevtype g%
\@CEMclspkgerror{Back-to-back inter-column glue specifiers in column\MessageBreak
specifications. Ignoring consecutive glue specifiers\MessageBreak
after the first}%
{You cannot have two or more glue types next to each other\MessageBreak 
in the CEMeqnarray column specifications.}%
\let\@CEMBPcurtype=a% abort this glue, future digits will be discarded
\@CEMBPcurnum=0\relax%
\else% if we previously aborted a glue
\if\@CEMBPprevtype a\@CEMBPcurnum=0\let\@CEMBPcurtype=a%maintain digit abortion
\else%acquire this number
% save the previous type before the numerical digits started
\if\@CEMBPprevtype n\else\let\@CEMBPprevsavedtype=\@CEMBPprevtype\fi%
\multiply\@CEMBPcurnum by 10\relax%
\advance\@CEMBPcurnum by #1\relax% add in number, \relax is needed to stop TeX's number scan
\if\@CEMBPnexttype n\else%close acquisition
\expandafter\ifx\csname @CEMeqnarraycolSEPDEF\expandafter\romannumeral\number\@CEMBPcurnum\endcsname\@CEMeqnarraycolisdefined%
\edef\@CEMBPcurglue{\csname @CEMeqnarraycolSEP\expandafter\romannumeral\number\@CEMBPcurnum\endcsname}%
\else%user glue not defined
\@CEMclspkgerror{Invalid user defined inter-column glue type "\number\@CEMBPcurnum" in\MessageBreak
column specifications. Using a default value of\MessageBreak
0pt instead}%
{You must define all CEMeqnarray numerical inter-column glue types via\MessageBreak
\string\CEMeqnarraydefcolsep \space before they are used in column specifications.}%
\edef\@CEMBPcurglue{\@CEMeqnarraycolSEPzero}%
\fi% glue defined or not
\let\@CEMBPcurtype=g% change the type to reflect the acquired glue
\let\@CEMBPprevtype=\@CEMBPprevsavedtype% restore the prev type before this number glue
\@CEMBPcurnum=0\relax%ready for next acquisition
\fi%close acquisition, get glue
\fi%discard or acquire number
\fi%prevtype glue or not
}


% process an acquired glue
% add any acquired column/glue pair to the preamble
\def\@CEMprocessGcol{\if\@CEMBPprevtype a\let\@CEMBPcurtype=a%maintain previous glue abortions
\else
% if this is the start glue, save it, but do nothing else 
% as this is not used in the preamble, but before
\if\@CEMBPprevtype s\edef\@CEMBPstartglue{\@CEMBPcurglue}%
\else%not the start glue
\if\@CEMBPprevtype g%ignore if back to back glues
\@CEMclspkgerror{Back-to-back inter-column glue specifiers in column\MessageBreak
specifications. Ignoring consecutive glue specifiers\MessageBreak
after the first}%
{You cannot have two or more glue types next to each other\MessageBreak 
in the CEMeqnarray column specifications.}%
\let\@CEMBPcurtype=a% abort this glue
\else% not a back to back glue
\if\@CEMBPprevtype c\relax% if the previoustype was a col, add column/glue pair to preamble
\ifnum\@CEMeqnnumcols>0\relax\@CEMappendtoksA{&}\fi
\toks0={##}%
% make preamble advance col counter if this environment needs this
\if@advanceCEMeqncolcnt\@CEMappendtoksA{\global\advance\@CEMeqncolcnt by 1\relax}\fi
% insert the column defintion into the preamble, being careful not to expand
% the column definition
\@CEMappendtoksA{\tabskip=\@CEMBPcurglue}%
\@CEMappendNOEXPANDtoksA{\begingroup\csname @CEMeqnarraycolPRE}%
\@CEMappendtoksA{\@CEMBPcurcolname}%
\@CEMappendNOEXPANDtoksA{\endcsname}%
\@CEMappendtoksA{\the\toks0}%
\@CEMappendNOEXPANDtoksA{\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\csname @CEMeqnarraycolPOST}%
\@CEMappendtoksA{\@CEMBPcurcolname}%
\@CEMappendNOEXPANDtoksA{\endcsname\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\endgroup}%
\advance\@CEMeqnnumcols by 1\relax%one more column in the preamble
\else% error: non-start glue with no pending column
\@CEMclspkgerror{Inter-column glue specifier without a prior column\MessageBreak
type in the column specifications. Ignoring this glue\MessageBreak 
specifier}%
{Except for the first and last positions, glue can be placed only\MessageBreak
between column types.}%
\let\@CEMBPcurtype=a% abort this glue
\fi% previous was a column
\fi% back-to-back glues
\fi% is start column glue
\fi% prev type not a
}


% process an acquired letter referenced column and, if necessary, add it to the preamble
\def\@CEMprocessCcol{\if\@CEMBPnexttype g\else
\if\@CEMBPnexttype n\else
% we have a column followed by something other than a glue (or numeral glue)
% so we must add this column to the preamble now
\ifnum\@CEMeqnnumcols>0\relax\@CEMappendtoksA{&}\fi%col separator for those after the first
\if\@CEMBPnexttype e\@CEMappendtoksA{\tabskip=\@CEMBPendglue\relax}\else%put in end glue
\@CEMappendtoksA{\tabskip=\@CEMeqnarraycolSEPdefaultmid\relax}\fi% or default mid glue
\toks0={##}%
% make preamble advance col counter if this environment needs this
\if@advanceCEMeqncolcnt\@CEMappendtoksA{\global\advance\@CEMeqncolcnt by 1\relax}\fi
% insert the column definition into the preamble, being careful not to expand
% the column definition
\@CEMappendNOEXPANDtoksA{\begingroup\csname @CEMeqnarraycolPRE}%
\@CEMappendtoksA{\@CEMBPcurcolname}%
\@CEMappendNOEXPANDtoksA{\endcsname}%
\@CEMappendtoksA{\the\toks0}%
\@CEMappendNOEXPANDtoksA{\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\csname @CEMeqnarraycolPOST}%
\@CEMappendtoksA{\@CEMBPcurcolname}%
\@CEMappendNOEXPANDtoksA{\endcsname\relax\relax\relax\relax\relax%
\relax\relax\relax\relax\relax\endgroup}%
\advance\@CEMeqnnumcols by 1\relax%one more column in the preamble
\fi%next type not numeral
\fi%next type not glue
}


%%
%% END OF CEMeqnarry DEFINITIONS
%%




% set up the running headings, this complex because of all the different
% modes CEMconf supports
\if@twoside
 \ifCLASSOPTIONtechnote
   \def\ps@headings{%
       \def\@oddhead{\hbox{}\scriptsize\leftmark \hfil \thepage}
       \def\@evenhead{\scriptsize\thepage \hfil \leftmark\hbox{}}
       \ifCLASSOPTIONdraftcls
            \ifCLASSOPTIONdraftclsnofoot
               \def\@oddfoot{}\def\@evenfoot{}%
            \else
               \def\@oddfoot{\scriptsize\@date\hfil DRAFT}
               \def\@evenfoot{\scriptsize DRAFT\hfil\@date}
            \fi
       \else
            \def\@oddfoot{}\def\@evenfoot{}
       \fi}
 \else % not a technote
   \def\ps@headings{%
       \ifCLASSOPTIONconference
        \def\@oddhead{}
        \def\@evenhead{}
       \else
        \def\@oddhead{\hbox{}\scriptsize\rightmark \hfil \thepage}
        \def\@evenhead{\scriptsize\thepage \hfil \leftmark\hbox{}}
       \fi
       \ifCLASSOPTIONdraftcls
            \def\@oddhead{\hbox{}\scriptsize\rightmark \hfil \thepage}
            \def\@evenhead{\scriptsize\thepage \hfil \leftmark\hbox{}}
            \ifCLASSOPTIONdraftclsnofoot
               \def\@oddfoot{}\def\@evenfoot{}%
            \else
               \def\@oddfoot{\scriptsize\@date\hfil DRAFT}
               \def\@evenfoot{\scriptsize DRAFT\hfil\@date}
            \fi
       \else
            \def\@oddfoot{}\def\@evenfoot{}%
       \fi}
 \fi
\else % single side
\def\ps@headings{%
    \ifCLASSOPTIONconference
     \def\@oddhead{}
     \def\@evenhead{}
    \else
     \def\@oddhead{\hbox{}\scriptsize\leftmark \hfil \thepage}
     \def\@evenhead{}
    \fi
    \ifCLASSOPTIONdraftcls
          \def\@oddhead{\hbox{}\scriptsize\leftmark \hfil \thepage}
          \def\@evenhead{}
          \ifCLASSOPTIONdraftclsnofoot
             \def\@oddfoot{}
          \else
             \def\@oddfoot{\scriptsize \@date \hfil DRAFT}
          \fi
    \else
         \def\@oddfoot{}
    \fi
    \def\@evenfoot{}}
\fi


% title page style
\def\ps@CEMtitlepagestyle{\def\@oddfoot{}\def\@evenfoot{}%
\ifCLASSOPTIONconference
   \def\@oddhead{}%
   \def\@evenhead{}%
\else
   \def\@oddhead{\hbox{}\scriptsize\leftmark \hfil \thepage}%
   \def\@evenhead{\scriptsize\thepage \hfil \leftmark\hbox{}}%
\fi
\ifCLASSOPTIONdraftcls
   \def\@oddhead{\hbox{}\scriptsize\leftmark \hfil \thepage}%
   \def\@evenhead{\scriptsize\thepage \hfil \leftmark\hbox{}}%
   \ifCLASSOPTIONdraftclsnofoot\else
      \def\@oddfoot{\scriptsize \@date\hfil DRAFT}%
      \def\@evenfoot{\scriptsize DRAFT\hfil \@date}%
   \fi
\else
   % all non-draft mode footers
   \if@CEMusingpubid
      % for title pages that are using a pubid
      % do not repeat pubid if using peer review option
      \ifCLASSOPTIONpeerreview
      \else
         \footskip 0pt%
         \ifCLASSOPTIONcompsoc
           \def\@oddfoot{\hss\normalfont\scriptsize\raisebox{-1.5\@CEMnormalsizeunitybaselineskip}[0ex][0ex]{\@CEMpubid}\hss}%
           \def\@evenfoot{\hss\normalfont\scriptsize\raisebox{-1.5\@CEMnormalsizeunitybaselineskip}[0ex][0ex]{\@CEMpubid}\hss}%
         \else
           \def\@oddfoot{\hss\normalfont\footnotesize\raisebox{1.5ex}[1.5ex]{\@CEMpubid}\hss}%
           \def\@evenfoot{\hss\normalfont\footnotesize\raisebox{1.5ex}[1.5ex]{\@CEMpubid}\hss}%
         \fi
      \fi
   \fi
\fi}


% peer review cover page style
\def\ps@CEMpeerreviewcoverpagestyle{%
\def\@oddhead{}\def\@evenhead{}%
\def\@oddfoot{}\def\@evenfoot{}%
\ifCLASSOPTIONdraftcls
   \ifCLASSOPTIONdraftclsnofoot\else
      \def\@oddfoot{\scriptsize \@date\hfil DRAFT}%
      \def\@evenfoot{\scriptsize DRAFT\hfil \@date}%
   \fi
\else
   % non-draft mode footers
   \if@CEMusingpubid
      \footskip 0pt%
      \ifCLASSOPTIONcompsoc
        \def\@oddfoot{\hss\normalfont\scriptsize\raisebox{-1.5\@CEMnormalsizeunitybaselineskip}[0ex][0ex]{\@CEMpubid}\hss}%
        \def\@evenfoot{\hss\normalfont\scriptsize\raisebox{-1.5\@CEMnormalsizeunitybaselineskip}[0ex][0ex]{\@CEMpubid}\hss}%
      \else
        \def\@oddfoot{\hss\normalfont\footnotesize\raisebox{1.5ex}[1.5ex]{\@CEMpubid}\hss}%
        \def\@evenfoot{\hss\normalfont\footnotesize\raisebox{1.5ex}[1.5ex]{\@CEMpubid}\hss}%
      \fi
   \fi
\fi}


% start with empty headings
\def\rightmark{}\def\leftmark{}


%% Defines the command for putting the header. \footernote{TEXT} is the same
%% as \markboth{TEXT}{TEXT}. 
%% Note that all the text is forced into uppercase, if you have some text
%% that needs to be in lower case, for instance et. al., then either manually
%% set \leftmark and \rightmark or use \MakeLowercase{et. al.} within the
%% arguments to \markboth.
\def\markboth#1#2{\def\leftmark{\@CEMcompsoconly{\sffamily}\MakeUppercase{#1}}%
\def\rightmark{\@CEMcompsoconly{\sffamily}\MakeUppercase{#2}}}
\def\footernote#1{\markboth{#1}{#1}}

\def\today{\ifcase\month\or
    January\or February\or March\or April\or May\or June\or
    July\or August\or September\or October\or November\or December\fi
    \space\number\day, \number\year}




%% CITATION AND BIBLIOGRAPHY COMMANDS
% 
% Modify Latex2e \@citex to separate citations with "], ["
\def\@citex[#1]#2{%
  \let\@citea\@empty
  \@cite{\@for\@citeb:=#2\do
    {\@citea\def\@citea{], [}%
     \edef\@citeb{\expandafter\@firstofone\@citeb\@empty}%
     \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
     \@ifundefined{b@\@citeb}{\mbox{\reset@font\bfseries ?}%
       \G@refundefinedtrue
       \@latex@warning
         {Citation `\@citeb' on page \thepage \space undefined}}%
       {\hbox{\csname b@\@citeb\endcsname}}}}{#1}}


\def\citepunct{], [}
\def\citedash{]--[}


\AtBeginDocument{\csname url@samestyle\endcsname}


\def\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty


\def\bstctlcite{\@ifnextchar[{\@bstctlcite}{\@bstctlcite[@auxout]}}
\def\@bstctlcite[#1]#2{\@bsphack
  \@for\@citeb:=#2\do{%
    \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \if@filesw\immediate\write\csname #1\endcsname{\string\citation{\@citeb}}\fi}%
  \@esphack}

\edef\@CEMtriggerrefnum{0}   % the default of zero means that
                              % the command is not executed
\def\@CEMtriggercmd{\newpage}

% allow the user to alter the triggered command
\long\def\CEMtriggercmd#1{\long\def\@CEMtriggercmd{#1}}

% allow user a way to specify the reference number just before the
% command is executed
\def\CEMtriggeratref#1{\@CEMconftmpcountA=#1%
\edef\@CEMtriggerrefnum{\the\@CEMconftmpcountA}}%

% trigger command at the given reference
\def\@CEMbibitemprefix{\@CEMconftmpcountA=\@CEMtriggerrefnum\relax%
\advance\@CEMconftmpcountA by -1\relax%
\ifnum\c@enumiv=\@CEMconftmpcountA\relax\@CEMtriggercmd\relax\fi}


\def\@biblabel#1{[#1]}

% compsoc journals left align the reference numbers
\@CEMcompsocnotconfonly{\def\@biblabel#1{[#1]\hfill}}

% controls bib item spacing
\def\CEMbibitemsep{0pt plus .5pt}

\@CEMcompsocconfonly{\def\CEMbibitemsep{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}}


\def\thebibliography#1{\section*{\refname}%
    \addcontentsline{toc}{section}{\refname}%
    
    \small\@CEMcompsocconfonly{\small}\vskip 0.3\baselineskip plus 0.1\baselineskip minus 0.1\baselineskip%
    \list{\@biblabel{\@arabic\c@enumiv}}%
    {\settowidth\labelwidth{\@biblabel{#1}}%
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep\relax
    \itemsep \CEMbibitemsep\relax
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}}%
    \let\@CEMlatexbibitem\bibitem%
    \def\bibitem{\@CEMbibitemprefix\@CEMlatexbibitem}%
\def\newblock{\hskip .11em plus .33em minus .07em}%
% originally:
%   \sloppy\clubpenalty4000\widowpenalty4000%
% by adding the \interlinepenalty here, we make it more
% difficult, but not impossible, for LaTeX to break within a reference.
% CEM almost never breaks a reference (but they do it more often with
% technotes). You may get an underfull vbox warning around the bibliography, 
% but the final result will be much more like what CEM will publish. 
% MDS 11/2000
\ifCLASSOPTIONtechnote\sloppy\clubpenalty4000\widowpenalty4000\interlinepenalty100%
\else\sloppy\clubpenalty4000\widowpenalty4000\interlinepenalty500\fi%
    \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist




% TITLE PAGE COMMANDS
% 
% 
% \CEMmembership is used to produce the sublargesize italic font used to indicate author 
% CEM membership. compsoc uses a large size sans slant font
\def\CEMmembership#1{{\@CEMnotcompsoconly{\sublargesize}\normalfont\@CEMcompsoconly{\sffamily}\textit{#1}}}
 

% \CEMauthorrefmark{} produces a footnote type symbol to indicate author affiliation.
% When given an argument of 1 to 9, \CEMauthorrefmark{} follows the standard LaTeX footnote
% symbol sequence convention. However, for arguments 10 and above, \CEMauthorrefmark{} 
% reverts to using lower case roman numerals, so it cannot overflow. Do note that you 
% cannot use \footnotemark[] in place of \CEMauthorrefmark{} within \author as the footnote
% symbols will have been turned off to prevent \thanks from creating footnote marks.
% \CEMauthorrefmark{} produces a symbol that appears to LaTeX as having zero vertical
% height - this allows for a more compact line packing, but the user must ensure that
% the interline spacing is large enough to prevent \CEMauthorrefmark{} from colliding
% with the text above.
% V1.7 make this a robust command
\DeclareRobustCommand*{\CEMauthorrefmark}[1]{\raisebox{0pt}[0pt][0pt]{\textsuperscript{\footnotesize\ensuremath{\ifcase#1\or *\or \dagger\or \ddagger\or%
    \mathsection\or \mathparagraph\or \|\or **\or \dagger\dagger%
    \or \ddagger\ddagger \else\textsuperscript{\expandafter\romannumeral#1}\fi}}}}


%% FONT CONTROLS AND SPACINGS FOR CONFERENCE MODE AUTHOR NAME AND AFFILIATION BLOCKS
%% 
%% The default font styles for the author name and affiliation blocks (confmode)
%\def\@CEMauthorblockNstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\sublargesize\@CEMcompsocconfonly{\large}}
%\def\@CEMauthorblockAstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\@CEMcompsocconfonly{\itshape}\normalsize\@CEMcompsocconfonly{\large}}
%% The default if the user does not use an author block
%\def\@CEMauthordefaulttextstyle{\normalfont\@CEMcompsocnotconfonly{\sffamily}\sublargesize}
%
%% spacing from title (or special paper notice) to author name blocks (confmode)
%% can be negative
%\def\@CEMauthorblockconfadjspace{-0.25em}
%% compsoc conferences need more space here
%\@CEMcompsocconfonly{\def\@CEMauthorblockconfadjspace{0.75\@CEMnormalsizeunitybaselineskip}}
%
%% spacing between name and affiliation blocks (confmode)
%% This can be negative.
%% CEM doesn't want any added spacing here, but I will leave these
%% controls in place in case they ever change their mind.
%% Personally, I like 0.75ex.
%%\def\@CEMauthorblockNtopspace{0.75ex}
%%\def\@CEMauthorblockAtopspace{0.75ex}
%\def\@CEMauthorblockNtopspace{0.0ex}
%\def\@CEMauthorblockAtopspace{0.0ex}
%% baseline spacing within name and affiliation blocks (confmode)
%% must be positive, spacings below certain values will make 
%% the position of line of text sensitive to the contents of the
%% line above it i.e., whether or not the prior line has descenders, 
%% subscripts, etc. For this reason it is a good idea to keep
%% these above 2.6ex
%\def\@CEMauthorblockNinterlinespace{2.6ex}
%\def\@CEMauthorblockAinterlinespace{2.75ex}
%
%% This tracks the required strut size.
%% See the \@CEMauthorhalign command for the actual default value used.
%\def\@CEMauthorblockXinterlinespace{2.7ex}

% variables to retain font size and style across groups
% values given here have no effect as they will be overwritten later
\gdef\@CEMSAVESTATEfontsize{10}
\gdef\@CEMSAVESTATEfontbaselineskip{12}
\gdef\@CEMSAVESTATEfontencoding{OT1}
\gdef\@CEMSAVESTATEfontfamily{ptm}
\gdef\@CEMSAVESTATEfontseries{m}
\gdef\@CEMSAVESTATEfontshape{n}

% saves the current font attributes
\def\@CEMcurfontSAVE{\global\let\@CEMSAVESTATEfontsize\f@size%
\global\let\@CEMSAVESTATEfontbaselineskip\f@baselineskip%
\global\let\@CEMSAVESTATEfontencoding\f@encoding%
\global\let\@CEMSAVESTATEfontfamily\f@family%
\global\let\@CEMSAVESTATEfontseries\f@series%
\global\let\@CEMSAVESTATEfontshape\f@shape}

% restores the saved font attributes
\def\@CEMcurfontRESTORE{\fontsize{\@CEMSAVESTATEfontsize}{\@CEMSAVESTATEfontbaselineskip}%
\fontencoding{\@CEMSAVESTATEfontencoding}%
\fontfamily{\@CEMSAVESTATEfontfamily}%
\fontseries{\@CEMSAVESTATEfontseries}%
\fontshape{\@CEMSAVESTATEfontshape}%
\selectfont}


% variable to indicate if the current block is the first block in the column
\newif\if@CEMprevauthorblockincol   \@CEMprevauthorblockincolfalse


% the command places a strut with height and depth = \@CEMauthorblockXinterlinespace
% we use this technique to have complete manual control over the spacing of the lines
% within the halign environment.
% We set the below baseline portion at 30%, the above
% baseline portion at 70% of the total length.
% Responds to changes in the document's \baselinestretch
\def\@CEMauthorstrutrule{\@CEMconftmpdimenA\@CEMauthorblockXinterlinespace%
\@CEMconftmpdimenA=\baselinestretch\@CEMconftmpdimenA%
\rule[-0.3\@CEMconftmpdimenA]{0pt}{\@CEMconftmpdimenA}}


% blocks to hold the authors' names and affilations. 
% Makes formatting easy for conferences
%
% use real definitions in conference mode
% name block
\def\CEMauthorblockN#1{\relax\@CEMauthorblockNstyle% set the default text style
\gdef\@CEMauthorblockXinterlinespace{0pt}% disable strut for spacer row
% the \expandafter hides the \cr in conditional tex, see the array.sty docs
% for details, probably not needed here as the \cr is in a macro
% do a spacer row if needed
\if@CEMprevauthorblockincol\expandafter\@CEMauthorblockNtopspaceline\fi
\global\@CEMprevauthorblockincoltrue% we now have a block in this column
%restore the correct strut value
\gdef\@CEMauthorblockXinterlinespace{\@CEMauthorblockNinterlinespace}%
% input the author names
#1%
% end the row if the user did not already
\crcr}
% spacer row for names
\def\@CEMauthorblockNtopspaceline{\cr\noalign{\vskip\@CEMauthorblockNtopspace}}
%
% affiliation block
\def\CEMauthorblockA#1{\relax\@CEMauthorblockAstyle% set the default text style
\gdef\@CEMauthorblockXinterlinespace{0pt}%disable strut for spacer row
% the \expandafter hides the \cr in conditional tex, see the array.sty docs
% for details, probably not needed here as the \cr is in a macro
% do a spacer row if needed
\if@CEMprevauthorblockincol\expandafter\@CEMauthorblockAtopspaceline\fi
\global\@CEMprevauthorblockincoltrue% we now have a block in this column
%restore the correct strut value
\gdef\@CEMauthorblockXinterlinespace{\@CEMauthorblockAinterlinespace}%
% input the author affiliations
#1%
% end the row if the user did not already
\crcr}
% spacer row for affiliations
\def\@CEMauthorblockAtopspaceline{\cr\noalign{\vskip\@CEMauthorblockAtopspace}}


% allow papers to compile even if author blocks are used in modes other
% than conference or peerreviewca. For such cases, we provide dummy blocks.
\ifCLASSOPTIONconference
\else
   \ifCLASSOPTIONpeerreviewca\else
      % not conference or peerreviewca mode
      \def\CEMauthorblockN#1{#1}%
      \def\CEMauthorblockA#1{#1}%
   \fi
\fi



% we provide our own halign so as not to have to depend on tabular
\def\@CEMauthorhalign{\@CEMauthordefaulttextstyle% default text style
   \lineskip=0pt\relax% disable line spacing
   \lineskiplimit=0pt\relax%
   \baselineskip=0pt\relax%
   \@CEMcurfontSAVE% save the current font
   \mathsurround\z@\relax% no extra spacing around math
   \let\\\@CEMauthorhaligncr% replace newline with halign friendly one
   \tabskip=0pt\relax% no column spacing
   \everycr{}% ensure no problems here
   \@CEMprevauthorblockincolfalse% no author blocks yet
   \def\@CEMauthorblockXinterlinespace{2.7ex}% default interline space
   \vtop\bgroup%vtop box
   \halign\bgroup&\relax\hfil\@CEMcurfontRESTORE\relax ##\relax
   \hfil\@CEMcurfontSAVE\@CEMauthorstrutrule\cr}

% ensure last line, exit from halign, close vbox
\def\end@CEMauthorhalign{\crcr\egroup\egroup}

% handle bogus star form
\def\@CEMauthorhaligncr{{\ifnum0=`}\fi\@ifstar{\@@CEMauthorhaligncr}{\@@CEMauthorhaligncr}}

% test and setup the optional argument to \\[]
\def\@@CEMauthorhaligncr{\@testopt\@@@CEMauthorhaligncr\z@skip}

% end the line and do the optional spacer
\def\@@@CEMauthorhaligncr[#1]{\ifnum0=`{\fi}\cr\noalign{\vskip#1\relax}}



% flag to prevent multiple \and warning messages
\newif\if@CEMWARNand
\@CEMWARNandtrue

% if in conference or peerreviewca modes, we support the use of \and as \author is a
% tabular environment, otherwise we warn the user that \and is invalid
% outside of conference or peerreviewca modes.
\def\and{\relax} % provide a bogus \and that we will then override

\renewcommand{\and}[1][\relax]{\if@CEMWARNand\typeout{** WARNING: \noexpand\and is valid only
                               when in conference or peerreviewca}\typeout{modes (line \the\inputlineno).}\fi\global\@CEMWARNandfalse}

\ifCLASSOPTIONconference%
\renewcommand{\and}[1][\hfill]{\end{@CEMauthorhalign}#1\begin{@CEMauthorhalign}}%
\fi
\ifCLASSOPTIONpeerreviewca
\renewcommand{\and}[1][\hfill]{\end{@CEMauthorhalign}#1\begin{@CEMauthorhalign}}%
\fi


% page clearing command
% based on LaTeX2e's \cleardoublepage, but allows different page styles
% for the inserted blank pages
\def\@CEMcleardoublepage#1{\clearpage\if@twoside\ifodd\c@page\else
\hbox{}\thispagestyle{#1}\newpage\if@twocolumn\hbox{}\thispagestyle{#1}\newpage\fi\fi\fi}


% user command to invoke the title page
\def\maketitle{\par%
  \begingroup%
  \normalfont%
  \def\thefootnote{}%  the \thanks{} mark type is empty
  \def\footnotemark{}% and kill space from \thanks within author
  \let\@makefnmark\relax% V1.7, must *really* kill footnotemark to remove all \textsuperscript spacing as well.
  \footnotesize%       equal spacing between thanks lines
  \footnotesep 0.7\baselineskip%see global setting of \footnotesep for more info
  % V1.7 disable \thanks note indention for compsoc
  \@CEMcompsoconly{\long\def\@makefntext##1{\parindent 1em\noindent\hbox{\@makefnmark}##1}}%
  \normalsize%
  \ifCLASSOPTIONpeerreview
     \newpage\global\@topnum\z@ \@maketitle\@CEMstatictitlevskip\@CEMaftertitletext%
     \thispagestyle{CEMpeerreviewcoverpagestyle}\@thanks%
  \else
     \if@twocolumn%
        \ifCLASSOPTIONtechnote%
           \newpage\global\@topnum\z@ \@maketitle\@CEMstatictitlevskip\@CEMaftertitletext%
        \else
           \twocolumn[\@maketitle\@CEMdynamictitlevspace\@CEMaftertitletext]%
        \fi
     \else
        \newpage\global\@topnum\z@ \@maketitle\@CEMstatictitlevskip\@CEMaftertitletext%
     \fi
     \thispagestyle{CEMtitlepagestyle}\@thanks%
  \fi
  % pullup page for pubid if used.
  \if@CEMusingpubid
     \enlargethispage{-\@CEMpubidpullup}%
  \fi 
  \endgroup
  \setcounter{footnote}{0}\let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}%
  % v1.6b do not clear these as we will need the title again for peer review papers
  % \gdef\@author{}\gdef\@title{}%
  \let\thanks\relax}



% V1.7 parbox to format \@CEMcompsoctitleabstractindextext
\long\def\@CEMcompsoctitleabstractindextextbox#1{\parbox{0.915\textwidth}{#1}}

% formats the Title, authors names, affiliations and special paper notice
% THIS IS A CONTROLLED SPACING COMMAND! Do not allow blank lines or unintentional
% spaces to enter the definition - use % at the end of each line
\def\@maketitle{\newpage
\begin{center}%
\ifCLASSOPTIONtechnote% technotes
   {\bfseries\large\@CEMcompsoconly{\sffamily}\@title\par}\vskip 1.3em{\lineskip .5em\@CEMcompsoconly{\sffamily}\@author
   \@CEMspecialpapernotice\par{\@CEMcompsoconly{\vskip 1.5em\relax
   \@CEMcompsoctitleabstractindextextbox{\@CEMcompsoctitleabstractindextext}\par
   \hfill\@CEMcompsocdiamondline\hfill\hbox{}\par}}}\relax
\else% not a technote
   \vskip0.2em{\Huge\@CEMcompsoconly{\sffamily}\@CEMcompsocconfonly{\normalfont\normalsize\vskip 2\@CEMnormalsizeunitybaselineskip
   \bfseries\Large}\@title\par}\vskip1.0em\par%
   % V1.6 handle \author differently if in conference mode
   \ifCLASSOPTIONconference%
      {\@CEMspecialpapernotice\mbox{}\vskip\@CEMauthorblockconfadjspace%
       \mbox{}\hfill\begin{@CEMauthorhalign}\@author\end{@CEMauthorhalign}\hfill\mbox{}\par}\relax
   \else% peerreviewca, peerreview or journal
      \ifCLASSOPTIONpeerreviewca
         % peerreviewca handles author names just like conference mode
         {\@CEMcompsoconly{\sffamily}\@CEMspecialpapernotice\mbox{}\vskip\@CEMauthorblockconfadjspace%
          \mbox{}\hfill\begin{@CEMauthorhalign}\@author\end{@CEMauthorhalign}\hfill\mbox{}\par
          {\@CEMcompsoconly{\vskip 1.5em\relax
           \@CEMcompsoctitleabstractindextextbox{\@CEMcompsoctitleabstractindextext}\par\hfill
           \@CEMcompsocdiamondline\hfill\hbox{}\par}}}\relax
      \else% journal or peerreview
         {\lineskip.5em\@CEMcompsoconly{\sffamily}\sublargesize\@author\@CEMspecialpapernotice\par
          {\@CEMcompsoconly{\vskip 1.5em\relax
           \@CEMcompsoctitleabstractindextextbox{\@CEMcompsoctitleabstractindextext}\par\hfill
           \@CEMcompsocdiamondline\hfill\hbox{}\par}}}\relax
      \fi
   \fi
\fi\end{center}}



% V1.7 Computer Society "diamond line" which follows index terms for nonconference papers
\def\@CEMcompsocdiamondline{\vrule depth 0pt height 0.5pt width 4cm\hspace{7.5pt}%
\raisebox{-3.5pt}{\fontfamily{pzd}\fontencoding{U}\fontseries{m}\fontshape{n}\fontsize{11}{12}\selectfont\char70}%
\hspace{7.5pt}\vrule depth 0pt height 0.5pt width 4cm\relax}

% V1.7 standard LateX2e \thanks, but with \itshape under compsoc. Also make it a \long\def
% We also need to trigger the one-shot footnote rule
\def\@CEMtriggeroneshotfootnoterule{\global\@CEMenableoneshotfootnoteruletrue}


\long\def\thanks#1{\footnotemark
    \protected@xdef\@thanks{\@thanks
        \protect\footnotetext[\the\c@footnote]{\@CEMcompsoconly{\itshape
        \protect\@CEMtriggeroneshotfootnoterule\relax}\ignorespaces#1}}}
\let\@thanks\@empty

% V1.7 allow \author to contain \par's. This is needed to allow \thanks to contain \par.
\long\def\author#1{\gdef\@author{#1}}


% in addition to setting up CEMitemize, we need to remove a baselineskip space above and
% below it because \list's \pars introduce blank lines because of the footnote struts.
\def\@CEMsetupcompsocitemizelist{\def\labelitemi{$\bullet$}%
%\def\@CEMsetupcompsocitemizelist{\def\labelitemi{$\hyphen$}%
\setlength{\CEMlabelindent}{0.5pt}\setlength{\parskip}{0pt}%
\setlength{\partopsep}{0pt}\setlength{\topsep}{0.5\baselineskip}\vspace{-1\baselineskip}\relax}


% flag for fake non-compsoc \CEMcompsocthanksitem - prevents line break on very first item
\newif\if@CEMbreakcompsocthanksitem \@CEMbreakcompsocthanksitemfalse

\ifCLASSOPTIONcompsoc
% V1.7 compsoc bullet item \thanks
% also, we need to redefine this to destroy the argument in \@CEMdynamictitlevspace
\long\def\CEMcompsocitemizethanks#1{\relax\@CEMbreakcompsocthanksitemfalse\footnotemark
    \protected@xdef\@thanks{\@thanks
        \protect\footnotetext[\the\c@footnote]{\itshape\protect\@CEMtriggeroneshotfootnoterule
        {\let\CEMiedlistdecl\relax\protect\begin{CEMitemize}[\protect\@CEMsetupcompsocitemizelist]\ignorespaces#1\relax
        \protect\end{CEMitemize}}\protect\vspace{-1\baselineskip}}}}
\DeclareRobustCommand*{\CEMcompsocthanksitem}{\item}
\else
% non-compsoc, allow for dual compilation via rerouting to normal \thanks
\long\def\CEMcompsocitemizethanks#1{\thanks{#1}}
% redirect to "pseudo-par" \hfil\break\indent after swallowing [] from \CEMcompsocthanksitem[]
\DeclareRobustCommand{\CEMcompsocthanksitem}{\@ifnextchar [{\@CEMthanksswallowoptionalarg}%
{\@CEMthanksswallowoptionalarg[\relax]}}
% be sure and break only after first item, be sure and ignore spaces after optional argument
\def\@CEMthanksswallowoptionalarg[#1]{\relax\if@CEMbreakcompsocthanksitem\hfil\break
\indent\fi\@CEMbreakcompsocthanksitemtrue\ignorespaces}
\fi


% V1.6b define the \CEMpeerreviewmaketitle as needed
\ifCLASSOPTIONpeerreview
\def\CEMpeerreviewmaketitle{\@CEMcleardoublepage{empty}%
\ifCLASSOPTIONtwocolumn
\twocolumn[\@CEMpeerreviewmaketitle\@CEMdynamictitlevspace]
\else
\newpage\@CEMpeerreviewmaketitle\@CEMstatictitlevskip
\fi
\thispagestyle{CEMtitlepagestyle}}
\else
% \CEMpeerreviewmaketitle does nothing if peer review option has not been selected
\def\CEMpeerreviewmaketitle{\relax}
\fi

% peerreview formats the repeated title like the title in journal papers.
\def\@CEMpeerreviewmaketitle{\begin{center}\@CEMcompsoconly{\sffamily}%
\normalfont\normalsize\vskip0.2em{\Huge\@title\par}\vskip1.0em\par
\end{center}}



% V1.6 
% this is a static rubber spacer between the title/authors and the main text
% used for single column text, or when the title appears in the first column
% of two column text (technotes). 
\def\@CEMstatictitlevskip{{\normalfont\normalsize
% adjust spacing to next text
% v1.6b handle peer review papers
\ifCLASSOPTIONpeerreview
% for peer review papers, the same value is used for both title pages
% regardless of the other paper modes
   \vskip 1\baselineskip plus 0.375\baselineskip minus 0.1875\baselineskip
\else
   \ifCLASSOPTIONconference% conference
      \vskip 1\baselineskip plus 0.375\baselineskip minus 0.1875\baselineskip%
   \else%
      \ifCLASSOPTIONtechnote% technote
         \vskip 1\baselineskip plus 0.375\baselineskip minus 0.1875\baselineskip%
      \else% journal uses more space
         \vskip 2.5\baselineskip plus 0.75\baselineskip minus 0.375\baselineskip%
      \fi
   \fi
\fi}}


% V1.6
% This is a dynamically determined rigid spacer between the title/authors 
% and the main text. This is used only for single column titles over two 
% column text (most common)
% This is bit tricky because we have to ensure that the textheight of the
% main text is an integer multiple of \baselineskip
% otherwise underfull vbox problems may develop in the second column of the
% text on the titlepage
% The possible use of \CEMpubid must also be taken into account.
\def\@CEMdynamictitlevspace{{%
    % we run within a group so that all the macros can be forgotten when we are done
    \long\def\thanks##1{\relax}%don't allow \thanks to run when we evaluate the vbox height
    \long\def\CEMcompsocitemizethanks##1{\relax}%don't allow \CEMcompsocitemizethanks to run when we evaluate the vbox height
    \normalfont\normalsize% we declare more descriptive variable names
    \let\@CEMmaintextheight=\@CEMconftmpdimenA%height of the main text columns
    \let\@CEMINTmaintextheight=\@CEMconftmpdimenB%height of the main text columns with integer # lines
    % set the nominal and minimum values for the title spacer
    % the dynamic algorithm will not allow the spacer size to
    % become less than \@CEMMINtitlevspace - instead it will be
    % lengthened
    % default to journal values
    \def\@CEMNORMtitlevspace{2.5\baselineskip}%
    \def\@CEMMINtitlevspace{2\baselineskip}%
    % conferences and technotes need tighter spacing
    \ifCLASSOPTIONconference%conference
     \def\@CEMNORMtitlevspace{1\baselineskip}%
     \def\@CEMMINtitlevspace{0.75\baselineskip}%
    \fi
    \ifCLASSOPTIONtechnote%technote
      \def\@CEMNORMtitlevspace{1\baselineskip}%
      \def\@CEMMINtitlevspace{0.75\baselineskip}%
    \fi%
    % get the height that the title will take up
    \ifCLASSOPTIONpeerreview
       \settoheight{\@CEMmaintextheight}{\vbox{\hsize\textwidth \@CEMpeerreviewmaketitle}}%
    \else
       \settoheight{\@CEMmaintextheight}{\vbox{\hsize\textwidth \@maketitle}}%
    \fi
    \@CEMmaintextheight=-\@CEMmaintextheight% title takes away from maintext, so reverse sign
    % add the height of the page textheight
    \advance\@CEMmaintextheight by \textheight%
    % correct for title pages using pubid
    \ifCLASSOPTIONpeerreview\else
       % peerreview papers use the pubid on the cover page only.
       % And the cover page uses a static spacer.
       \if@CEMusingpubid\advance\@CEMmaintextheight by -\@CEMpubidpullup\fi
    \fi%
    % subtract off the nominal value of the title bottom spacer
    \advance\@CEMmaintextheight by -\@CEMNORMtitlevspace%
    % \topskip takes away some too
    \advance\@CEMmaintextheight by -\topskip%
    % calculate the column height of the main text for lines
    % now we calculate the main text height as if holding
    % an integer number of \normalsize lines after the first
    % and discard any excess fractional remainder
    % we subtracted the first line, because the first line
    % is placed \topskip into the maintext, not \baselineskip like the
    % rest of the lines.
    \@CEMINTmaintextheight=\@CEMmaintextheight%
    \divide\@CEMINTmaintextheight  by \baselineskip%
    \multiply\@CEMINTmaintextheight  by \baselineskip%
    % now we calculate how much the title spacer height will
    % have to be reduced from nominal (\@CEMREDUCEmaintextheight is always
    % a positive value) so that the maintext area will contain an integer
    % number of normal size lines
    % we change variable names here (to avoid confusion) as we no longer
    % need \@CEMINTmaintextheight and can reuse its dimen register
    \let\@CEMREDUCEmaintextheight=\@CEMINTmaintextheight%
    \advance\@CEMREDUCEmaintextheight by -\@CEMmaintextheight%
    \advance\@CEMREDUCEmaintextheight by \baselineskip%
    % this is the calculated height of the spacer
    % we change variable names here (to avoid confusion) as we no longer
    % need \@CEMmaintextheight and can reuse its dimen register
    \let\@CEMCOMPENSATElen=\@CEMmaintextheight%
    \@CEMCOMPENSATElen=\@CEMNORMtitlevspace% set the nominal value
    % we go with the reduced length if it is smaller than an increase
    \ifdim\@CEMREDUCEmaintextheight < 0.5\baselineskip\relax%
     \advance\@CEMCOMPENSATElen by -\@CEMREDUCEmaintextheight%
     % if the resulting spacer is too small back out and go with an increase instead
     \ifdim\@CEMCOMPENSATElen<\@CEMMINtitlevspace\relax%
      \advance\@CEMCOMPENSATElen by \baselineskip%
     \fi%
    \else%
     % go with an increase because it is closer to the nominal than a decrease
     \advance\@CEMCOMPENSATElen by -\@CEMREDUCEmaintextheight%
     \advance\@CEMCOMPENSATElen by \baselineskip%
    \fi%
    % set the calculated rigid spacer
    \vspace{\@CEMCOMPENSATElen}}}



% V1.6
% we allow the user access to the last part of the title area
% useful in emergencies such as when a different spacing is needed
% This text is NOT compensated for in the dynamic sizer.
\let\@CEMaftertitletext=\relax
\long\def\CEMaftertitletext#1{\def\@CEMaftertitletext{#1}}

% V1.7 provide a way for users to enter abstract and keywords
% into the onecolumn title are. This text is compensated for
% in the dynamic sizer.
\let\@CEMcompsoctitleabstractindextext=\relax
\long\def\CEMcompsoctitleabstractindextext#1{\def\@CEMcompsoctitleabstractindextext{#1}}
% V1.7 provide a way for users to get the \@CEMcompsoctitleabstractindextext if
% not in compsoc journal mode - this way abstract and keywords can be placed
% in their conventional position if not in compsoc mode.
\def\CEMdisplaynotcompsoctitleabstractindextext{%
\ifCLASSOPTIONcompsoc% display if compsoc conf
\ifCLASSOPTIONconference\@CEMcompsoctitleabstractindextext\fi
\else% or if not compsoc
\@CEMcompsoctitleabstractindextext\fi}


% command to allow alteration of baselinestretch, but only if the current
% baselineskip is unity. Used to tweak the compsoc abstract and keywords line spacing.
\def\@CEMtweakunitybaselinestretch#1{{\def\baselinestretch{1}\selectfont
\global\@tempskipa\baselineskip}\ifnum\@tempskipa=\baselineskip%
\def\baselinestretch{#1}\selectfont\fi\relax}


% abstract and keywords are in \small, except 
% for 9pt docs in which they are in \footnotesize
% Because 9pt docs use an 8pt footnotesize, \small
% becomes a rather awkward 8.5pt
\def\@CEMabskeysecsize{\small}
\ifx\CLASSOPTIONpt\@CEMptsizenine
 \def\@CEMabskeysecsize{\footnotesize}
\fi

% compsoc journals use \footnotesize, compsoc conferences use normalsize
\@CEMcompsoconly{\def\@CEMabskeysecsize{\footnotesize}}
\@CEMcompsocconfonly{\def\@CEMabskeysecsize{\normalsize}}




% V1.6 have abstract and keywords strip leading spaces, pars and newlines
% so that spacing is more tightly controlled.
\def\abstract{\normalfont
    \if@twocolumn
      %\@CEMabskeysecsize\bfseries\textit{\abstractname}---\relax
      %\@CEMabskeysecsize\bfseries{\abstractname} \relax
      \@CEMabskeysecsize{\abstractname} \relax
    \else
      \begin{center}\vspace{-1.78ex}\@CEMabskeysecsize\textbf{\abstractname}\end{center}\quotation\@CEMabskeysecsize
    \fi\@CEMgobbleleadPARNLSP}
% V1.6 CEM wants only 1 pica from end of abstract to introduction heading when in 
% conference mode (the heading already has this much above it)
\def\endabstract{\relax\ifCLASSOPTIONconference\vspace{0ex}\else\vspace{1.34ex}\fi\par\if@twocolumn\else\endquotation\fi
    \normalfont\normalsize}

\def\CEMkeywords{\normalfont
    \if@twocolumn
      \@CEMabskeysecsize\bfseries\textit{\CEMkeywordsname}---\relax
    \else
      \begin{center}\@CEMabskeysecsize\textbf{\CEMkeywordsname}\end{center}\quotation\@CEMabskeysecsize
    \fi\@CEMgobbleleadPARNLSP}
\def\endCEMkeywords{\relax\ifCLASSOPTIONtechnote\vspace{1.34ex}\else\vspace{0.67ex}\fi
    \par\if@twocolumn\else\endquotation\fi%
    \normalfont\normalsize}

% V1.7 compsoc keywords index terms
\ifCLASSOPTIONcompsoc
  \ifCLASSOPTIONconference% compsoc conference
\def\abstract{\normalfont
      \begin{center}\@CEMabskeysecsize\textbf{\large\abstractname}\end{center}\vskip 0.5\baselineskip plus 0.1\baselineskip minus 0.1\baselineskip
      \if@twocolumn\else\quotation\fi\itshape\@CEMabskeysecsize%
      \par\@CEMgobbleleadPARNLSP}
\def\CEMkeywords{\normalfont\vskip 1.5\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip
      \begin{center}\@CEMabskeysecsize\textbf{\large\CEMkeywordsname}\end{center}\vskip 0.5\baselineskip plus 0.1\baselineskip minus 0.1\baselineskip
      \if@twocolumn\else\quotation\fi\itshape\@CEMabskeysecsize%
      \par\@CEMgobbleleadPARNLSP}
  \else% compsoc not conference
\def\abstract{\normalfont\@CEMtweakunitybaselinestretch{1.15}\sffamily
    \if@twocolumn
      \@CEMabskeysecsize\noindent\textbf{\abstractname}---\relax
    \else
      \begin{center}\vspace{-1.78ex}\@CEMabskeysecsize\textbf{\abstractname}\end{center}\quotation\@CEMabskeysecsize%
    \fi\@CEMgobbleleadPARNLSP}
\def\CEMkeywords{\normalfont\@CEMtweakunitybaselinestretch{1.15}\sffamily
    \if@twocolumn
      \@CEMabskeysecsize\vskip 0.5\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip\noindent
      \textbf{\CEMkeywordsname}---\relax
    \else
      \begin{center}\@CEMabskeysecsize\textbf{\CEMkeywordsname}\end{center}\quotation\@CEMabskeysecsize%
    \fi\@CEMgobbleleadPARNLSP}
  \fi
\fi



% gobbles all leading \, \\ and \par, upon finding first token that
% is not a \ , \\ or a \par, it ceases and returns that token
% 
% used to strip leading \, \\ and \par from the input
% so that such things in the beginning of an environment will not
% affect the formatting of the text
\long\def\@CEMgobbleleadPARNLSP#1{\let\@CEMswallowthistoken=0%
\let\@CEMgobbleleadPARNLSPtoken#1%
\let\@CEMgobbleleadPARtoken=\par%
\let\@CEMgobbleleadNLtoken=\\%
\let\@CEMgobbleleadSPtoken=\ %
\def\@CEMgobbleleadSPMACRO{\ }%
\ifx\@CEMgobbleleadPARNLSPtoken\@CEMgobbleleadPARtoken%
\let\@CEMswallowthistoken=1%
\fi%
\ifx\@CEMgobbleleadPARNLSPtoken\@CEMgobbleleadNLtoken%
\let\@CEMswallowthistoken=1%
\fi%
\ifx\@CEMgobbleleadPARNLSPtoken\@CEMgobbleleadSPtoken%
\let\@CEMswallowthistoken=1%
\fi%
% a control space will come in as a macro
% when it is the last one on a line
\ifx\@CEMgobbleleadPARNLSPtoken\@CEMgobbleleadSPMACRO%
\let\@CEMswallowthistoken=1%
\fi%
% if we have to swallow this token, do so and taste the next one
% else spit it out and stop gobbling
\ifx\@CEMswallowthistoken 1\let\@CEMnextgobbleleadPARNLSP=\@CEMgobbleleadPARNLSP\else%
\let\@CEMnextgobbleleadPARNLSP=#1\fi%
\@CEMnextgobbleleadPARNLSP}%




% TITLING OF SECTIONS
\def\@CEMsectpunct{:\ \,}  % Punctuation after run-in section heading  (headings which are
                            % part of the paragraphs), need little bit more than a single space
                            % spacing from section number to title
% compsoc conferences use regular period/space punctuation
\ifCLASSOPTIONcompsoc
\ifCLASSOPTIONconference
\def\@CEMsectpunct{.\ }
\fi\fi


\def\@seccntformat#1{\csname the#1dis\endcsname\hskip 0.5em\relax}

\ifCLASSOPTIONcompsoc
% compsoc journals need extra spacing
\ifCLASSOPTIONconference\else
\def\@seccntformat#1{\csname the#1dis\endcsname\hskip 1em\relax}
\fi\fi

%v1.7 put {} after #6 to allow for some types of user font control
%and use \@@par rather than \par
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
     \let\@svsec\@empty
  \else
     \refstepcounter{#1}%
     % load section label and spacer into \@svsec
     \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi%
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@% tempskipa determines whether is treated as a high
     \begingroup #6{\relax% or low level heading
      \noindent % subsections are NOT indented
       % print top level headings. \@svsec is label, #8 is heading title
       % CEM does not block indent the section title text, it flows like normal
       {\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\@@par}}%
     \endgroup
     \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth\relax\else
               \protect\numberline{\csname the#1\endcsname}\fi#7}%
  \else % printout low level headings
     % svsechd seems to swallow the trailing space, protect it with \mbox{}
     % got rid of sectionmark stuff
     \def\@svsechd{#6{\hskip #3\relax\@svsec #8\@CEMsectpunct\mbox{}}%
     \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth\relax\else
               \protect\numberline{\csname the#1\endcsname}\fi#7}}%
  \fi%skip down
  \@xsect{#5}}


% section* handler
%v1.7 put {} after #4 to allow for some types of user font control
%and use \@@par rather than \par
\def\@ssect#1#2#3#4#5{\@tempskipa #3\relax
  \ifdim \@tempskipa>\z@
     %\begingroup #4\@hangfrom{\hskip #1}{\interlinepenalty \@M #5\par}\endgroup
     % CEM does not block indent the section title text, it flows like normal
     \begingroup \noindent #4{\relax{\hskip #1}{\interlinepenalty \@M #5\@@par}}\endgroup
  % svsechd swallows the trailing space, protect it with \mbox{}
  \else \def\@svsechd{#4{\hskip #1\relax #5\@CEMsectpunct\mbox{}}}\fi
  \@xsect{#3}}


%% SECTION heading spacing and font
%%
% arguments are: #1 - sectiontype name
% (for \@sect)   #2 - section level
%                #3 - section heading indent
%                #4 - top separation (absolute value used, neg indicates not to indent main text)
%                     If negative, make stretch parts negative too!
%                #5 - (absolute value used) positive: bottom separation after heading,
%                      negative: amount to indent main text after heading
%                Both #4 and #5 negative means to indent main text and use negative top separation
%                #6 - font control
% You've got to have \normalfont\normalsize in the font specs below to prevent
% trouble when you do something like:
% \section{Note}{\ttfamily TT-TEXT} is known to ... 
% CEM sometimes REALLY stretches the area before a section
% heading by up to about 0.5in. However, it may not be a good
% idea to let LaTeX have quite this much rubber.
\ifCLASSOPTIONconference%
% CEM wants section heading spacing to decrease for conference mode
\def\section{\@startsection{section}{1}{\z@}{18pt}%
{6pt}{\normalfont\normalsize\flushleft\textbf}}%
%{0.7ex plus 1ex minus 0ex}{\normalfont\normalsize\centering\scshape}}%
\def\subsection{\@startsection{subsection}{2}{\z@}{5pt plus 1.5ex minus 0.5ex}%
%{0.7ex plus .5ex minus 0ex}{\normalfont\normalsize\itshape}}%
{5pt plus .5ex minus 0ex}{\normalfont\normalsize\flushleft\textbf}}%
\else % for journals
\def\section{\@startsection{section}{1}{\z@}{3.0ex plus 1.5ex minus 1.5ex}
{0.7ex plus 1ex minus 0ex}{\normalfont\normalsize\centering\scshape}}%
\def\subsection{\@startsection{subsection}{2}{\z@}{3.5ex plus 1.5ex minus 1.5ex}%
{0.7ex plus .5ex minus 0ex}{\normalfont\normalsize\itshape}}%
\fi

% for both journals and conferences
% decided to put in a little rubber above the section, might help somebody
\def\subsubsection{\@startsection{subsubsection}{3}{0.7cm}{5pt plus 1.0ex minus 1.0ex}%
{5pt}{\normalfont\normalsize\itshape}}%
\def\paragraph{\@startsection{paragraph}{4}{2\parindent}{0ex plus 0.1ex minus 0.1ex}%
{0ex}{\normalfont\normalsize\itshape}}%


% compsoc
\ifCLASSOPTIONcompsoc
\ifCLASSOPTIONconference
% compsoc conference
\def\section{\@startsection{section}{1}{\z@}{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}%
{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}{\normalfont\large\bfseries}}%
\def\subsection{\@startsection{subsection}{2}{\z@}{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}%
{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}{\normalfont\sublargesize\bfseries}}%
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{1\baselineskip plus 0.25\baselineskip minus 0.25\baselineskip}%
{0ex}{\normalfont\normalsize\bfseries}}%
\def\paragraph{\@startsection{paragraph}{4}{2\parindent}{0ex plus 0.1ex minus 0.1ex}%
{0ex}{\normalfont\normalsize}}%
\else% compsoc journals
% use negative top separation as compsoc journals do not indent paragraphs after section titles
\def\section{\@startsection{section}{1}{\z@}{-3ex plus -2ex minus -1.5ex}%
{0.7ex plus 1ex minus 0ex}{\normalfont\large\sffamily\bfseries\scshape}}%
% Note that subsection and smaller may not be correct for the Computer Society,
% I have to look up an example.
\def\subsection{\@startsection{subsection}{2}{\z@}{-3.5ex plus -1.5ex minus -1.5ex}%
{0.7ex plus .5ex minus 0ex}{\normalfont\normalsize\sffamily\bfseries}}%
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-2.5ex plus -1ex minus -1ex}%
{0.5ex plus 0.5ex minus 0ex}{\normalfont\normalsize\sffamily\itshape}}%
\def\paragraph{\@startsection{paragraph}{4}{2\parindent}{-0ex plus -0.1ex minus -0.1ex}%
{0ex}{\normalfont\normalsize}}%
\fi\fi




%% ENVIRONMENTS
% "box" symbols at end of proofs
\def\CEMQEDclosed{\mbox{\rule[0pt]{1.3ex}{1.3ex}}} % for a filled box
% V1.6 some journals use an open box instead that will just fit around a closed one
\def\CEMQEDopen{{\setlength{\fboxsep}{0pt}\setlength{\fboxrule}{0.2pt}\fbox{\rule[0pt]{0pt}{1.3ex}\rule[0pt]{1.3ex}{0pt}}}}
\ifCLASSOPTIONcompsoc
\def\CEMQED{\CEMQEDopen}   % default to open for compsoc
\else
\def\CEMQED{\CEMQEDclosed} % otherwise default to closed
\fi

% v1.7 name change to avoid namespace collision with amsthm. Also add support
% for an optional argument.
\def\CEMproof{\@ifnextchar[{\@CEMproof}{\@CEMproof[\CEMproofname]}}
\def\@CEMproof[#1]{\par\noindent\hspace{2em}{\itshape #1: }}
\def\endCEMproof{\hspace*{\fill}~\CEMQED\par}


%\itemindent is set to \z@ by list, so define new temporary variable
\newdimen\@CEMtmpitemindent
\def\@begintheorem#1#2{\@CEMtmpitemindent\itemindent\topsep 0pt\rmfamily\trivlist%
    \item[\hskip \labelsep{\indent\itshape #1\ #2:}]\itemindent\@CEMtmpitemindent}
\def\@opargbegintheorem#1#2#3{\@CEMtmpitemindent\itemindent\topsep 0pt\rmfamily \trivlist%
% V1.6 CEM is back to using () around theorem names which are also in italics
% Thanks to Christian Peel for reporting this.
    \item[\hskip\labelsep{\indent\itshape #1\ #2\ (#3):}]\itemindent\@CEMtmpitemindent}
% V1.7 remove bogus \unskip that caused equations in theorems to collide with
% lines below.
\def\@endtheorem{\endtrivlist}

% V1.6
% display command for the section the theorem is in - so that \thesection
% is not used as this will be in Roman numerals when we want arabic.
% LaTeX2e uses \def\@thmcounter#1{\noexpand\arabic{#1}} for the theorem number
% (second part) display and \def\@thmcountersep{.} as a separator.
% V1.7 intercept calls to the section counter and reroute to \@CEMthmcounterinsection
% to allow \appendix(ices} to override as needed.
%
% special handler for sections, allows appendix(ices) to override
\gdef\@CEMthmcounterinsection#1{\arabic{#1}}
% string macro
\edef\@CEMstringsection{section}

% redefine the #1#2[#3] form of newtheorem to use a hook to \@CEMthmcounterinsection
% if section in_counter is used
\def\@xnthm#1#2[#3]{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}\@newctr{#1}[#3]%
     \edef\@CEMstringtmp{#3}
     \ifx\@CEMstringtmp\@CEMstringsection
     \expandafter\xdef\csname the#1\endcsname{%
     \noexpand\@CEMthmcounterinsection{#3}\@thmcountersep
          \@thmcounter{#1}}%
     \else
     \expandafter\xdef\csname the#1\endcsname{%
       \expandafter\noexpand\csname the#3\endcsname \@thmcountersep
          \@thmcounter{#1}}%
     \fi
     \global\@namedef{#1}{\@thm{#1}{#2}}%
     \global\@namedef{end#1}{\@endtheorem}}}



%% SET UP THE DEFAULT PAGESTYLE
\ps@headings
\pagenumbering{arabic}

% normally the page counter starts at 1
\setcounter{page}{1}
% however, for peerreview the cover sheet is page 0 or page -1
% (for duplex printing)
\ifCLASSOPTIONpeerreview
   \if@twoside
      \setcounter{page}{-1}
   \else
      \setcounter{page}{0}
   \fi
\fi

% standard book class behavior - let bottom line float up and down as
% needed when single sided
\ifCLASSOPTIONtwoside\else\raggedbottom\fi
% if two column - turn on twocolumn, allow word spacings to stretch more and
% enforce a rigid position for the last lines
\ifCLASSOPTIONtwocolumn
% the peer review option delays invoking twocolumn
   \ifCLASSOPTIONpeerreview\else
      \twocolumn
   \fi
\sloppy 
\flushbottom
\fi




% \APPENDIX and \APPENDICES definitions

% This is the \@ifmtarg command from the LaTeX ifmtarg package
% by Peter Wilson (CUA) and Donald Arseneau
% \@ifmtarg is used to determine if an argument to a command
% is present or not.
% For instance:
% \@ifmtarg{#1}{\typeout{empty}}{\typeout{has something}}
% \@ifmtarg is used with our redefined \section command if
% \appendices is invoked.
% The command \section will behave slightly differently depending
% on whether the user specifies a title: 
% \section{My appendix title}
% or not:
% \section{}
% This way, we can eliminate the blank lines where the title
% would be, and the unneeded : after Appendix in the table of
% contents 
\begingroup
\catcode`\Q=3
\long\gdef\@ifmtarg#1{\@xifmtarg#1QQ\@secondoftwo\@firstoftwo\@nil}
\long\gdef\@xifmtarg#1#2Q#3#4#5\@nil{#4}
\endgroup
% end of \@ifmtarg defs


% V1.7
% command that allows the one time saving of the original definition
% of section to \@CEMappendixsavesection for \appendix or \appendices 
% we don't save \section here as it may be redefined later by other
% packages (hyperref.sty, etc.)
\def\@CEMsaveoriginalsectiononce{\let\@CEMappendixsavesection\section
\let\@CEMsaveoriginalsectiononce\relax}

% neat trick to grab and process the argument from \section{argument}
% we process differently if the user invoked \section{} with no
% argument (title)
% note we reroute the call to the old \section*
\def\@CEMprocessthesectionargument#1{%
\@ifmtarg{#1}{%
\@CEMappendixsavesection*{\appendixname~\thesectiondis}%
\addcontentsline{toc}{section}{\appendixname~\thesection}}{%
\@CEMappendixsavesection*{\appendixname~\thesectiondis \\* #1}%
\addcontentsline{toc}{section}{\appendixname~\thesection: #1}}}

% we use this if the user calls \section{} after
% \appendix-- which has no meaning. So, we ignore the
% command and its argument. Then, warn the user.
\def\@CEMdestroythesectionargument#1{\typeout{** WARNING: Ignoring useless
\protect\section\space in Appendix (line \the\inputlineno).}}


% remember \thesection forms will be displayed in \ref calls
% and in the Table of Contents.
% The \sectiondis form is used in the actual heading itself

% appendix command for one single appendix
% normally has no heading. However, if you want a 
% heading, you can do so via the optional argument:
% \appendix[Optional Heading]
\def\appendix{\relax}
\renewcommand{\appendix}[1][]{\@CEMsaveoriginalsectiononce\par
    % v1.6 keep hyperref's identifiers unique
    \gdef\theHsection{Appendix.A}%
    % v1.6 adjust hyperref's string name for the section
    \xdef\Hy@chapapp{appendix}%
    \setcounter{section}{0}%
    \setcounter{subsection}{0}%
    \setcounter{subsubsection}{0}%
    \setcounter{paragraph}{0}%
    \gdef\thesection{A}%
    \gdef\thesectiondis{}% 
    \gdef\thesubsection{\Alph{subsection}}%
    \gdef\@CEMthmcounterinsection##1{A}
    \refstepcounter{section}% update the \ref counter
    \@ifmtarg{#1}{\@CEMappendixsavesection*{\appendixname}%
                  \addcontentsline{toc}{section}{\appendixname}}{%
             \@CEMappendixsavesection*{\appendixname~\\* #1}%
             \addcontentsline{toc}{section}{\appendixname: #1}}%
    % redefine \section command for appendix
    % leave \section* as is
    \def\section{\@ifstar{\@CEMappendixsavesection*}{%
                    \@CEMdestroythesectionargument}}% throw out the argument
                                                     % of the normal form
}



% appendices command for multiple appendices
% user then calls \section with an argument (possibly empty) to
% declare the individual appendices
\def\appendices{\@CEMsaveoriginalsectiononce\par
    % v1.6 keep hyperref's identifiers unique
    \gdef\theHsection{Appendix.\Alph{section}}%
    % v1.6 adjust hyperref's string name for the section
    \xdef\Hy@chapapp{appendix}%
    \setcounter{section}{-1}% we want \refstepcounter to use section 0
    \setcounter{subsection}{0}%
    \setcounter{subsubsection}{0}%
    \setcounter{paragraph}{0}%
    \ifCLASSOPTIONromanappendices%
    \gdef\thesection{\Roman{section}}%
    \gdef\thesectiondis{\Roman{section}}%
    \@CEMcompsocconfonly{\gdef\thesectiondis{\Roman{section}.}}%
    \gdef\@CEMthmcounterinsection##1{A\arabic{##1}}
    \else%
    \gdef\thesection{\Alph{section}}%
    \gdef\thesectiondis{\Alph{section}}%
    \@CEMcompsocconfonly{\gdef\thesectiondis{\Alph{section}.}}%
    \gdef\@CEMthmcounterinsection##1{\Alph{##1}}
    \fi%
    \refstepcounter{section}% update the \ref counter
    \setcounter{section}{0}% NEXT \section will be the FIRST appendix
    % redefine \section command for appendices
    % leave \section* as is
    \def\section{\@ifstar{\@CEMappendixsavesection*}{% process the *-form
                    \refstepcounter{section}% or is a new section so,
                    \@CEMprocessthesectionargument}}% process the argument 
                                                 % of the normal form
}



\def\@CEMPARstartDROPLINES{2}
\def\@CEMPARstartMINPAGELINES{2}
\def\@CEMPARstartHEIGHTTEXT{T}
\def\@CEMPARstartDROPDEPTH{1.1\baselineskip}
\def\@CEMPARstartFONTSTYLE{\bfseries}
\def\@CEMPARstartCAPSTYLE{\MakeUppercase}
\def\@CEMPARstartWORDFONTSTYLE{\relax}
\def\@CEMPARstartWORDCAPSTYLE{\MakeUppercase}
\def\@CEMPARstartSEP{0.15em}
\def\@CEMPARstartHOFFSET{0em}
\def\@CEMPARstartITLCORRECT{\/}
\ifCLASSOPTIONcompsoc
\def\@CEMPARstartFONTSTYLE{\mdseries}
\def\@CEMPARstartWORDFONTSTYLE{\scshape}
\def\@CEMPARstartWORDCAPSTYLE{\relax}
\fi

\def\CEMPARstart#1#2{\par{%
% if this page does not have enough space, break it and lets start
% on a new one
\@CEMconfneedspace{\@CEMPARstartMINPAGELINES\baselineskip}{\relax}%
% V1.7 move this up here in case user uses \textbf for \@CEMPARstartFONTSTYLE
% which uses command \leavevmode which causes an unwanted \indent to be issued
\noindent
% calculate the desired height of the big letter
% it extends from the top of \@CEMPARstartHEIGHTTEXT in the current font
% down to \@CEMPARstartDROPDEPTH below the current baseline
\settoheight{\@CEMconftmpdimenA}{\@CEMPARstartHEIGHTTEXT}%
\addtolength{\@CEMconftmpdimenA}{\@CEMPARstartDROPDEPTH}%
% extract the name of the current font in bold
% and place it in \@CEMPARstartFONTNAME
\def\@CEMPARstartGETFIRSTWORD##1 ##2\relax{##1}%
{\@CEMPARstartFONTSTYLE{\selectfont\edef\@CEMPARstartFONTNAMESPACE{\fontname\font\space}%
\xdef\@CEMPARstartFONTNAME{\expandafter\@CEMPARstartGETFIRSTWORD\@CEMPARstartFONTNAMESPACE\relax}}}%
% define a font based on this name with a point size equal to the desired
% height of the drop letter
\font\@CEMPARstartsubfont\@CEMPARstartFONTNAME\space at \@CEMconftmpdimenA\relax%
% save this value as a counter (integer) value (sp points)
\@CEMconftmpcountA=\@CEMconftmpdimenA%
% now get the height of the actual letter produced by this font size
\settoheight{\@CEMconftmpdimenB}{\@CEMPARstartsubfont\@CEMPARstartCAPSTYLE{#1}}%
% If something bogus happens like the first argument is empty or the
% current font is strange, do not allow a zero height.
\ifdim\@CEMconftmpdimenB=0pt\relax%
\typeout{** WARNING: CEMPARstart drop letter has zero height! (line \the\inputlineno)}%
\typeout{ Forcing the drop letter font size to 10pt.}%
\@CEMconftmpdimenB=10pt%
\fi%
% and store it as a counter
\@CEMconftmpcountB=\@CEMconftmpdimenB%
% Since a font size doesn't exactly correspond to the height of the capital
% letters in that font, the actual height of the letter, \@CEMconftmpcountB,
% will be less than that desired, \@CEMconftmpcountA
% we need to raise the font size, \@CEMconftmpdimenA 
% by \@CEMconftmpcountA / \@CEMconftmpcountB
% But, TeX doesn't have floating point division, so we have to use integer
% division. Hence the use of the counters.
% We need to reduce the denominator so that the loss of the remainder will
% have minimal affect on the accuracy of the result
\divide\@CEMconftmpcountB by 200%
\divide\@CEMconftmpcountA by \@CEMconftmpcountB%
% Then reequalize things when we use TeX's ability to multiply by
% floating point values
\@CEMconftmpdimenB=0.005\@CEMconftmpdimenA%
\multiply\@CEMconftmpdimenB by \@CEMconftmpcountA%
% \@CEMPARstartfont is globaly set to the calculated font of the big letter
% We need to carry this out of the local calculation area to to create the
% big letter.
\global\font\@CEMPARstartfont\@CEMPARstartFONTNAME\space at \@CEMconftmpdimenB%
% Now set \@CEMconftmpdimenA to the width of the big letter
% We need to carry this out of the local calculation area to set the
% hanging indent
\settowidth{\global\@CEMconftmpdimenA}{\@CEMPARstartfont
\@CEMPARstartCAPSTYLE{#1\@CEMPARstartITLCORRECT}}}%
% end of the isolated calculation environment
% add in the extra clearance we want
\advance\@CEMconftmpdimenA by \@CEMPARstartSEP\relax%
% add in the optional offset
\advance\@CEMconftmpdimenA by \@CEMPARstartHOFFSET\relax%
% V1.7 don't allow negative offsets to produce negative hanging indents
\@CEMconftmpdimenB\@CEMconftmpdimenA
\ifnum\@CEMconftmpdimenB < 0 \@CEMconftmpdimenB 0pt\fi
% \@CEMconftmpdimenA has the width of the big letter plus the
% separation space and \@CEMPARstartfont is the font we need to use
% Now, we make the letter and issue the hanging indent command
% The letter is placed in a box of zero width and height so that other
% text won't be displaced by it.
\hangindent\@CEMconftmpdimenB\hangafter=-\@CEMPARstartDROPLINES%
\makebox[0pt][l]{\hspace{-\@CEMconftmpdimenA}%
\raisebox{-\@CEMPARstartDROPDEPTH}[0pt][0pt]{\hspace{\@CEMPARstartHOFFSET}%
\@CEMPARstartfont\@CEMPARstartCAPSTYLE{#1\@CEMPARstartITLCORRECT}%
\hspace{\@CEMPARstartSEP}}}%
{\@CEMPARstartWORDFONTSTYLE{\@CEMPARstartWORDCAPSTYLE{\selectfont#2}}}}






% determines if the space remaining on a given page is equal to or greater
% than the specified space of argument one
% if not, execute argument two (only if the remaining space is greater than zero)
% and issue a \newpage
% 
% example: \@CEMconfneedspace{2in}{\vfill}
% 
% Does not take into consideration rubber shrinkage, so it tends to
% be overly cautious
% Based on an example posted by Donald Arseneau
% Note this macro uses \@CEMconftmpdimenB internally for calculations,
% so DO NOT PASS \@CEMconftmpdimenB to this routine
% if you need a dimen register, import with \@CEMconftmpdimenA instead
\def\@CEMconfneedspace#1#2{\penalty-100\begingroup%shield temp variable
\@CEMconftmpdimenB\pagegoal\advance\@CEMconftmpdimenB-\pagetotal% space left
\ifdim #1>\@CEMconftmpdimenB\relax% not enough space left
\ifdim\@CEMconftmpdimenB>\z@\relax #2\fi%
\newpage%
\fi\endgroup}



% CEMbiography ENVIRONMENT
% Allows user to enter biography leaving place for picture (adapts to font size)
% As of V1.5, a new optional argument allows you to have a real graphic!
% V1.5 and later also fixes the "colliding biographies" which could happen when a 
% biography's text was shorter than the space for the photo.
% MDS 7/2001
% V1.6 prevent multiple biographies from making multiple TOC entries
\newif\if@CEMbiographyTOCentrynotmade
\global\@CEMbiographyTOCentrynotmadetrue

% biography counter so hyperref can jump directly to the biographies
% and not just the previous section
\newcounter{CEMbiography}
\setcounter{CEMbiography}{0}

% photo area size
\def\@CEMBIOphotowidth{1.0in}    % width of the biography photo area
\def\@CEMBIOphotodepth{1.25in}   % depth (height) of the biography photo area
% area cleared for photo
\def\@CEMBIOhangwidth{1.14in}    % width cleared for the biography photo area
\def\@CEMBIOhangdepth{1.25in}    % depth cleared for the biography photo area
                                  % actual depth will be a multiple of 
                                  % \baselineskip, rounded up
\def\@CEMBIOskipN{4\baselineskip}% nominal value of the vskip above the biography

\newenvironment{CEMbiography}[2][]{\normalfont\@CEMcompsoconly{\sffamily}\footnotesize%
\unitlength 1in\parskip=0pt\par\parindent 1em\interlinepenalty500%
% we need enough space to support the hanging indent
% the nominal value of the spacer
% and one extra line for good measure
\@CEMconftmpdimenA=\@CEMBIOhangdepth%
\advance\@CEMconftmpdimenA by \@CEMBIOskipN%
\advance\@CEMconftmpdimenA by 1\baselineskip%
% if this page does not have enough space, break it and lets start
% with a new one
\@CEMconfneedspace{\@CEMconftmpdimenA}{\relax}%
% nominal spacer can strech, not shrink use 1fil so user can out stretch with \vfill
\vskip \@CEMBIOskipN plus 1fil minus 0\baselineskip%
% the default box for where the photo goes
\def\@CEMtempbiographybox{{\setlength{\fboxsep}{0pt}\framebox{%
\begin{minipage}[b][\@CEMBIOphotodepth][c]{\@CEMBIOphotowidth}\centering PLACE\\ PHOTO\\ HERE \end{minipage}}}}%
%
% detect if the optional argument was supplied, this requires the
% \@ifmtarg command as defined in the appendix section above
% and if so, override the default box with what they want
\@ifmtarg{#1}{\relax}{\def\@CEMtempbiographybox{\mbox{\begin{minipage}[b][\@CEMBIOphotodepth][c]{\@CEMBIOphotowidth}%
\centering%
#1%
\end{minipage}}}}% end if optional argument supplied
% Make an entry into the table of contents only if we have not done so before
\if@CEMbiographyTOCentrynotmade%
% link labels to the biography counter so hyperref will jump
% to the biography, not the previous section
\setcounter{CEMbiography}{-1}%
\refstepcounter{CEMbiography}%
\addcontentsline{toc}{section}{Biographies}%
\global\@CEMbiographyTOCentrynotmadefalse%
\fi%
% one more biography
\refstepcounter{CEMbiography}%
% Make an entry for this name into the table of contents 
\addcontentsline{toc}{subsection}{#2}%
% V1.6 properly handle if a new paragraph should occur while the
% hanging indent is still active. Do this by redefining \par so
% that it will not start a new paragraph. (But it will appear to the
% user as if it did.) Also, strip any leading pars, newlines, or spaces.
\let\@CEMBIOORGparCMD=\par% save the original \par command
\edef\par{\hfil\break\indent}% the new \par will not be a "real" \par
\settoheight{\@CEMconftmpdimenA}{\@CEMtempbiographybox}% get height of biography box
\@CEMconftmpdimenB=\@CEMBIOhangdepth%
\@CEMconftmpcountA=\@CEMconftmpdimenB% countA has the hang depth
\divide\@CEMconftmpcountA by \baselineskip%  calculates lines needed to produce the hang depth
\advance\@CEMconftmpcountA by 1% ensure we overestimate
% set the hanging indent
\hangindent\@CEMBIOhangwidth%
\hangafter-\@CEMconftmpcountA%
% reference the top of the photo area to the top of a capital T
\settoheight{\@CEMconftmpdimenB}{\mbox{T}}%
% set the photo box, give it zero width and height so as not to disturb anything
\noindent\makebox[0pt][l]{\hspace{-\@CEMBIOhangwidth}\raisebox{\@CEMconftmpdimenB}[0pt][0pt]{%
\raisebox{-\@CEMBIOphotodepth}[0pt][0pt]{\@CEMtempbiographybox}}}%
% now place the author name and begin the bio text
\noindent\textbf{#2\ }\@CEMgobbleleadPARNLSP}{\relax\let\par=\@CEMBIOORGparCMD\par%
% 7/2001 V1.5 detect when the biography text is shorter than the photo area
% and pad the unused area - preventing a collision from the next biography entry
% MDS
\ifnum \prevgraf <\@CEMconftmpcountA\relax% detect when the biography text is shorter than the photo
    \advance\@CEMconftmpcountA by -\prevgraf% calculate how many lines we need to pad
    \advance\@CEMconftmpcountA by -1\relax% we compensate for the fact that we indented an extra line
    \@CEMconftmpdimenA=\baselineskip% calculate the length of the padding
    \multiply\@CEMconftmpdimenA by \@CEMconftmpcountA%
    \noindent\rule{0pt}{\@CEMconftmpdimenA}% insert an invisible support strut
\fi%
\par\normalfont}



% V1.6
% added biography without a photo environment
\newenvironment{CEMbiographynophoto}[1]{%
% Make an entry into the table of contents only if we have not done so before
\if@CEMbiographyTOCentrynotmade%
% link labels to the biography counter so hyperref will jump
% to the biography, not the previous section
\setcounter{CEMbiography}{-1}%
\refstepcounter{CEMbiography}%
\addcontentsline{toc}{section}{Biographies}%
\global\@CEMbiographyTOCentrynotmadefalse%
\fi%
% one more biography
\refstepcounter{CEMbiography}%
% Make an entry for this name into the table of contents 
\addcontentsline{toc}{subsection}{#1}%
\normalfont\@CEMcompsoconly{\sffamily}\footnotesize\interlinepenalty500%
\vskip 4\baselineskip plus 1fil minus 0\baselineskip%
\parskip=0pt\par%
\noindent\textbf{#1\ }\@CEMgobbleleadPARNLSP}{\relax\par\normalfont}


% provide the user with some old font commands
% got this from article.cls
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}


% SPECIAL PAPER NOTICE COMMANDS
% 
% holds the special notice text
\def\@CEMspecialpapernotice{\relax}
 
% for special papers, like invited papers, the user can do:
% \CEMspecialpapernotice{(Invited Paper)} before \maketitle
\def\CEMspecialpapernotice#1{\ifCLASSOPTIONconference%
\def\@CEMspecialpapernotice{{\sublargesize\textit{#1}\vspace*{1em}}}%
\else%
\def\@CEMspecialpapernotice{{\\*[1.5ex]\sublargesize\textit{#1}}\vspace*{-2ex}}%
\fi}




% PUBLISHER ID COMMANDS
% to insert a publisher's ID footer
% V1.6 \CEMpubid has been changed so that the change in page size and style
% occurs in \maketitle. \CEMpubid must now be issued prior to \maketitle
% use \CEMpubidadjcol as before - in the second column of the title page
% These changes allow \maketitle to take the reduced page height into
% consideration when dynamically setting the space between the author 
% names and the maintext.
%
% the amount the main text is pulled up to make room for the
% publisher's ID footer
% CEM uses about 1.3\baselineskip for journals, 
% dynamic title spacing will clean up the fraction
\def\@CEMpubidpullup{1.3\baselineskip}
\ifCLASSOPTIONtechnote
% for technotes it must be an integer of baselineskip as there can be no
% dynamic title spacing for two column mode technotes (the title is in the
% in first column) and we should maintain an integer number of lines in the
% second column
% There are some examples (such as older issues of "Transactions on
% Information Theory") in which CEM really pulls the text off the ID for
% technotes - about 0.55in (or 4\baselineskip). We'll use 2\baselineskip
% and call it even.
\def\@CEMpubidpullup{2\baselineskip}
\fi

% V1.7 compsoc does not use a pullup
\ifCLASSOPTIONcompsoc
\def\@CEMpubidpullup{0pt}
\fi

% holds the ID text
\def\@CEMpubid{\relax}

% flag so \maketitle can tell if \CEMpubid was called
\newif\if@CEMusingpubid
\global\@CEMusingpubidfalse
% issue this command in the page to have the ID at the bottom
% V1.6 use before \maketitle
\def\CEMpubid#1{\def\@CEMpubid{#1}\global\@CEMusingpubidtrue}


% command which will pull up (shorten) the column it is executed in
% to make room for the publisher ID. Place in the second column of
% the title page when using \CEMpubid
% Is smart enough not to do anything when in single column text or
% if the user hasn't called \CEMpubid
% currently needed in for the second column of a page with the
% publisher ID. If not needed in future releases, please provide this
% command and define it as \relax for backward compatibility
% v1.6b do not allow command to operate if the peer review option has been 
% selected because \CEMpubidadjcol will not be on the cover page.
% V1.7 do nothing if compsoc
\def\CEMpubidadjcol{\ifCLASSOPTIONcompsoc\else\ifCLASSOPTIONpeerreview\else
\if@twocolumn\if@CEMusingpubid\enlargethispage{-\@CEMpubidpullup}\fi\fi\fi\fi}

% Special thanks to Peter Wilson, Daniel Luecking, and the other
% gurus at comp.text.tex, for helping me to understand how best to
% implement the CEMpubid command in LaTeX.



%% Lockout some commands under various conditions

% general purpose bit bucket
\newsavebox{\@CEMconfrubishbin}

% flags to prevent multiple warning messages
\newif\if@CEMWARNthanks
\newif\if@CEMWARNCEMPARstart
\newif\if@CEMWARNCEMbiography
\newif\if@CEMWARNCEMbiographynophoto
\newif\if@CEMWARNCEMpubid
\newif\if@CEMWARNCEMpubidadjcol
\newif\if@CEMWARNCEMmembership
\newif\if@CEMWARNCEMaftertitletext
\@CEMWARNthankstrue
\@CEMWARNCEMPARstarttrue
\@CEMWARNCEMbiographytrue
\@CEMWARNCEMbiographynophototrue
\@CEMWARNCEMpubidtrue
\@CEMWARNCEMpubidadjcoltrue
\@CEMWARNCEMmembershiptrue
\@CEMWARNCEMaftertitletexttrue


%% Lockout some commands when in various modes, but allow them to be restored if needed
%%
% save commands which might be locked out
% so that the user can later restore them if needed
\let\@CEMSAVECMDthanks\thanks
\let\@CEMSAVECMDCEMPARstart\CEMPARstart
\let\@CEMSAVECMDCEMbiography\CEMbiography
\let\@CEMSAVECMDendCEMbiography\endCEMbiography
\let\@CEMSAVECMDCEMbiographynophoto\CEMbiographynophoto
\let\@CEMSAVECMDendCEMbiographynophoto\endCEMbiographynophoto
\let\@CEMSAVECMDCEMpubid\CEMpubid
\let\@CEMSAVECMDCEMpubidadjcol\CEMpubidadjcol
\let\@CEMSAVECMDCEMmembership\CEMmembership
\let\@CEMSAVECMDCEMaftertitletext\CEMaftertitletext


% disable \CEMPARstart when in draft mode
% This may have originally been done because the pre-V1.6 drop letter
% algorithm had problems with a non-unity baselinestretch
% At any rate, it seems too formal to have a drop letter in a draft
% paper.
\ifCLASSOPTIONdraftcls
\def\CEMPARstart#1#2{#1#2\if@CEMWARNCEMPARstart\typeout{** ATTENTION: \noexpand\CEMPARstart
 is disabled in draft mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMPARstartfalse}
\fi
% and for technotes
\ifCLASSOPTIONtechnote
\def\CEMPARstart#1#2{#1#2\if@CEMWARNCEMPARstart\typeout{** WARNING: \noexpand\CEMPARstart
 is locked out for technotes (line \the\inputlineno).}\fi\global\@CEMWARNCEMPARstartfalse}
\fi


% lockout unneeded commands when in conference mode
\ifCLASSOPTIONconference
% when locked out, \thanks, \CEMbiography, \CEMbiographynophoto, \CEMpubid,
% \CEMmembership and \CEMaftertitletext will all swallow their given text. 
% \CEMPARstart will output a normal character instead
% warn the user about these commands only once to prevent the console screen
% from filling up with redundant messages
\def\thanks#1{\if@CEMWARNthanks\typeout{** WARNING: \noexpand\thanks
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNthanksfalse}
\def\CEMPARstart#1#2{#1#2\if@CEMWARNCEMPARstart\typeout{** WARNING: \noexpand\CEMPARstart
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMPARstartfalse}


% LaTeX treats environments and commands with optional arguments differently.
% the actual ("internal") command is stored as \\commandname 
% (accessed via \csname\string\commandname\endcsname )
% the "external" command \commandname is a macro with code to determine
% whether or not the optional argument is presented and to provide the 
% default if it is absent. So, in order to save and restore such a command
% we would have to save and restore \\commandname as well. But, if LaTeX
% ever changes the way it names the internal names, the trick would break.
% Instead let us just define a new environment so that the internal
% name can be left undisturbed.
\newenvironment{@CEMbogusbiography}[2][]{\if@CEMWARNCEMbiography\typeout{** WARNING: \noexpand\CEMbiography
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMbiographyfalse%
\setbox\@CEMconfrubishbin\vbox\bgroup}{\egroup\relax}
% and make biography point to our bogus biography
\let\CEMbiography=\@CEMbogusbiography
\let\endCEMbiography=\end@CEMbogusbiography

\renewenvironment{CEMbiographynophoto}[1]{\if@CEMWARNCEMbiographynophoto\typeout{** WARNING: \noexpand\CEMbiographynophoto
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMbiographynophotofalse%
\setbox\@CEMconfrubishbin\vbox\bgroup}{\egroup\relax}

\def\CEMpubid#1{\if@CEMWARNCEMpubid\typeout{** WARNING: \noexpand\CEMpubid 
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMpubidfalse}
\def\CEMpubidadjcol{\if@CEMWARNCEMpubidadjcol\typeout{** WARNING: \noexpand\CEMpubidadjcol
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMpubidadjcolfalse}
\def\CEMmembership#1{\if@CEMWARNCEMmembership\typeout{** WARNING: \noexpand\CEMmembership
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMmembershipfalse}
\def\CEMaftertitletext#1{\if@CEMWARNCEMaftertitletext\typeout{** WARNING: \noexpand\CEMaftertitletext
 is locked out when in conference mode (line \the\inputlineno).}\fi\global\@CEMWARNCEMaftertitletextfalse}
\fi


% provide a way to restore the commands that are locked out
\def\CEMoverridecommandlockouts{%
\typeout{** ATTENTION: Overriding command lockouts (line \the\inputlineno).}%
\let\thanks\@CEMSAVECMDthanks%
\let\CEMPARstart\@CEMSAVECMDCEMPARstart%
\let\CEMbiography\@CEMSAVECMDCEMbiography%
\let\endCEMbiography\@CEMSAVECMDendCEMbiography%
\let\CEMbiographynophoto\@CEMSAVECMDCEMbiographynophoto%
\let\endCEMbiographynophoto\@CEMSAVECMDendCEMbiographynophoto%
\let\CEMpubid\@CEMSAVECMDCEMpubid%
\let\CEMpubidadjcol\@CEMSAVECMDCEMpubidadjcol%
\let\CEMmembership\@CEMSAVECMDCEMmembership%
\let\CEMaftertitletext\@CEMSAVECMDCEMaftertitletext}



% need a backslash character for typeout output
{\catcode`\|=0 \catcode`\\=12
|xdef|@CEMbackslash{\}}


% hook to allow easy disabling of all legacy warnings
\def\@CEMlegacywarn#1#2{\typeout{** ATTENTION: \@CEMbackslash #1 is deprecated (line \the\inputlineno).
Use \@CEMbackslash #2 instead.}}


% provide for legacy commands
\def\authorblockA{\@CEMlegacywarn{authorblockA}{CEMauthorblockA}\CEMauthorblockA}
\def\authorblockN{\@CEMlegacywarn{authorblockN}{CEMauthorblockN}\CEMauthorblockN}
\def\authorrefmark{\@CEMlegacywarn{authorrefmark}{CEMauthorrefmark}\CEMauthorrefmark}
\def\PARstart{\@CEMlegacywarn{PARstart}{CEMPARstart}\CEMPARstart}
\def\pubid{\@CEMlegacywarn{pubid}{CEMpubid}\CEMpubid}
\def\pubidadjcol{\@CEMlegacywarn{pubidadjcol}{CEMpubidadjcol}\CEMpubidadjcol}
\def\QED{\@CEMlegacywarn{QED}{CEMQED}\CEMQED}
\def\QEDclosed{\@CEMlegacywarn{QEDclosed}{CEMQEDclosed}\CEMQEDclosed}
\def\QEDopen{\@CEMlegacywarn{QEDopen}{CEMQEDopen}\CEMQEDopen}
\def\specialpapernotice{\@CEMlegacywarn{specialpapernotice}{CEMspecialpapernotice}\CEMspecialpapernotice}



% provide for legacy environments
\def\biography{\@CEMlegacywarn{biography}{CEMbiography}\CEMbiography}
\def\biographynophoto{\@CEMlegacywarn{biographynophoto}{CEMbiographynophoto}\CEMbiographynophoto}
\def\keywords{\@CEMlegacywarn{keywords}{CEMkeywords}\CEMkeywords}
\def\endbiography{\endCEMbiography}
\def\endbiographynophoto{\endCEMbiographynophoto}
\def\endkeywords{\endCEMkeywords}


% provide for legacy IED commands/lengths when possible
\let\labelindent\CEMlabelindent
\def\calcleftmargin{\@CEMlegacywarn{calcleftmargin}{CEMcalcleftmargin}\CEMcalcleftmargin}
\def\setlabelwidth{\@CEMlegacywarn{setlabelwidth}{CEMsetlabelwidth}\CEMsetlabelwidth}
\def\usemathlabelsep{\@CEMlegacywarn{usemathlabelsep}{CEMusemathlabelsep}\CEMusemathlabelsep}
\def\iedlabeljustifyc{\@CEMlegacywarn{iedlabeljustifyc}{CEMiedlabeljustifyc}\CEMiedlabeljustifyc}
\def\iedlabeljustifyl{\@CEMlegacywarn{iedlabeljustifyl}{CEMiedlabeljustifyl}\CEMiedlabeljustifyl}
\def\iedlabeljustifyr{\@CEMlegacywarn{iedlabeljustifyr}{CEMiedlabeljustifyr}\CEMiedlabeljustifyr}



% let \proof use the CEMconf version even after amsthm is loaded
% \proof is now deprecated in favor of \CEMproof
\AtBeginDocument{\def\proof{\@CEMlegacywarn{proof}{CEMproof}\CEMproof}\def\endproof{\endCEMproof}}

% V1.7 \overrideCEMmargins is no longer supported.
\def\overrideCEMmargins{%
\typeout{** WARNING: \string\overrideCEMmargins \space no longer supported (line \the\inputlineno).}%
\typeout{** Use the \string\CLASSINPUTinnersidemargin, \string\CLASSINPUToutersidemargin \space controls instead.}}


\endinput

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End of CEMconf.cls  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% That's all folks!

